/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.VerticalAlignment;

public class FlowArrangementTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(FlowArrangementTests.class);
    }

    public FlowArrangementTests(String string) {
        super(string);
    }

    public void testEquals() {
        FlowArrangement flowArrangement = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement flowArrangement2 = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)flowArrangement.equals(flowArrangement2));
        FlowArrangementTests.assertTrue((boolean)flowArrangement2.equals(flowArrangement));
        flowArrangement = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertFalse((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        FlowArrangementTests.assertFalse((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        FlowArrangementTests.assertFalse((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        FlowArrangementTests.assertTrue((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        FlowArrangementTests.assertFalse((boolean)flowArrangement.equals(flowArrangement2));
        flowArrangement2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        FlowArrangementTests.assertTrue((boolean)flowArrangement.equals(flowArrangement2));
    }

    public void testCloning() {
        FlowArrangement flowArrangement = new FlowArrangement();
        FlowArrangementTests.assertFalse((boolean)(flowArrangement instanceof Cloneable));
    }

    public void testSerialization() {
        FlowArrangement flowArrangement = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement flowArrangement2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(flowArrangement);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            flowArrangement2 = (FlowArrangement)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        FlowArrangementTests.assertEquals((Object)flowArrangement, flowArrangement2);
    }
}

