/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.EmptyBlock;

public class EmptyBlockTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(EmptyBlockTests.class);
    }

    public EmptyBlockTests(String string) {
        super(string);
    }

    public void testEquals() {
        EmptyBlock emptyBlock = new EmptyBlock(1.0, 2.0);
        EmptyBlock emptyBlock2 = new EmptyBlock(1.0, 2.0);
        EmptyBlockTests.assertTrue((boolean)emptyBlock.equals(emptyBlock2));
        EmptyBlockTests.assertTrue((boolean)emptyBlock2.equals(emptyBlock2));
        emptyBlock = new EmptyBlock(1.1, 2.0);
        EmptyBlockTests.assertFalse((boolean)emptyBlock.equals(emptyBlock2));
        emptyBlock2 = new EmptyBlock(1.1, 2.0);
        EmptyBlockTests.assertTrue((boolean)emptyBlock.equals(emptyBlock2));
        emptyBlock = new EmptyBlock(1.1, 2.2);
        EmptyBlockTests.assertFalse((boolean)emptyBlock.equals(emptyBlock2));
        emptyBlock2 = new EmptyBlock(1.1, 2.2);
        EmptyBlockTests.assertTrue((boolean)emptyBlock.equals(emptyBlock2));
    }

    public void testCloning() {
        EmptyBlock emptyBlock = new EmptyBlock(1.0, 2.0);
        EmptyBlock emptyBlock2 = null;
        try {
            emptyBlock2 = (EmptyBlock)emptyBlock.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            EmptyBlockTests.fail((String)cloneNotSupportedException.toString());
        }
        EmptyBlockTests.assertTrue((emptyBlock != emptyBlock2 ? 1 : 0) != 0);
        EmptyBlockTests.assertTrue((emptyBlock.getClass() == emptyBlock2.getClass() ? 1 : 0) != 0);
        EmptyBlockTests.assertTrue((boolean)emptyBlock.equals(emptyBlock2));
    }

    public void testSerialization() {
        EmptyBlock emptyBlock = new EmptyBlock(1.0, 2.0);
        EmptyBlock emptyBlock2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(emptyBlock);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            emptyBlock2 = (EmptyBlock)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            EmptyBlockTests.fail((String)exception.toString());
        }
        EmptyBlockTests.assertEquals((Object)emptyBlock, emptyBlock2);
    }
}

