/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.VerticalAlignment;

public class ColumnArrangementTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ColumnArrangementTests.class);
    }

    public ColumnArrangementTests(String string) {
        super(string);
    }

    public void testEquals() {
        ColumnArrangement columnArrangement = new ColumnArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangement columnArrangement2 = new ColumnArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)columnArrangement.equals(columnArrangement2));
        ColumnArrangementTests.assertTrue((boolean)columnArrangement2.equals(columnArrangement));
        columnArrangement = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertFalse((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        ColumnArrangementTests.assertFalse((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        ColumnArrangementTests.assertFalse((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        ColumnArrangementTests.assertTrue((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        ColumnArrangementTests.assertFalse((boolean)columnArrangement.equals(columnArrangement2));
        columnArrangement2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        ColumnArrangementTests.assertTrue((boolean)columnArrangement.equals(columnArrangement2));
    }

    public void testCloning() {
        FlowArrangement flowArrangement = new FlowArrangement();
        ColumnArrangementTests.assertFalse((boolean)(flowArrangement instanceof Cloneable));
    }

    public void testSerialization() {
        FlowArrangement flowArrangement = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement flowArrangement2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(flowArrangement);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            flowArrangement2 = (FlowArrangement)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        ColumnArrangementTests.assertEquals((Object)flowArrangement, flowArrangement2);
    }
}

