/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;

public class BorderArrangementTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(BorderArrangementTests.class);
    }

    public BorderArrangementTests(String string) {
        super(string);
    }

    public void testEquals() {
        BorderArrangement borderArrangement = new BorderArrangement();
        BorderArrangement borderArrangement2 = new BorderArrangement();
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
        BorderArrangementTests.assertTrue((boolean)borderArrangement2.equals(borderArrangement));
        borderArrangement.add(new EmptyBlock(99.0, 99.0), null);
        BorderArrangementTests.assertFalse((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement2.add(new EmptyBlock(99.0, 99.0), null);
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement.add(new EmptyBlock(1.0, 1.0), RectangleEdge.LEFT);
        BorderArrangementTests.assertFalse((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement2.add(new EmptyBlock(1.0, 1.0), RectangleEdge.LEFT);
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement.add(new EmptyBlock(2.0, 2.0), RectangleEdge.RIGHT);
        BorderArrangementTests.assertFalse((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement2.add(new EmptyBlock(2.0, 2.0), RectangleEdge.RIGHT);
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement.add(new EmptyBlock(3.0, 3.0), RectangleEdge.TOP);
        BorderArrangementTests.assertFalse((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement2.add(new EmptyBlock(3.0, 3.0), RectangleEdge.TOP);
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement.add(new EmptyBlock(4.0, 4.0), RectangleEdge.BOTTOM);
        BorderArrangementTests.assertFalse((boolean)borderArrangement.equals(borderArrangement2));
        borderArrangement2.add(new EmptyBlock(4.0, 4.0), RectangleEdge.BOTTOM);
        BorderArrangementTests.assertTrue((boolean)borderArrangement.equals(borderArrangement2));
    }

    public void testCloning() {
        BorderArrangement borderArrangement = new BorderArrangement();
        BorderArrangementTests.assertFalse((boolean)(borderArrangement instanceof Cloneable));
    }

    public void testSerialization() {
        BorderArrangement borderArrangement = new BorderArrangement();
        BorderArrangement borderArrangement2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(borderArrangement);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            borderArrangement2 = (BorderArrangement)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            BorderArrangementTests.fail((String)exception.toString());
        }
        BorderArrangementTests.assertEquals((Object)borderArrangement, borderArrangement2);
    }

    public void testSizing() {
        BlockContainer blockContainer = new BlockContainer(new BorderArrangement());
        BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Size2D size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)0.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)0.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.add(new EmptyBlock(123.4, 567.8));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)123.4, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)567.8, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)22.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        EmptyBlock emptyBlock = new EmptyBlock(12.3, 15.6);
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(emptyBlock, RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)22.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)size2D.height, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)emptyBlock.getBounds().getHeight(), (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)22.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        EmptyBlock emptyBlock2 = new EmptyBlock(12.3, 15.6);
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(emptyBlock2, RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)22.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)size2D.height, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)emptyBlock2.getBounds().getHeight(), (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)22.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(5.4, 3.2), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)27.7, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)31.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)31.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)31.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)33.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)33.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)33.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)12.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.3, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)14.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)12.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D);
        BorderArrangementTests.assertEquals((double)21.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
    }

    public void testSizingWithWidthConstraint() {
        RectangleConstraint rectangleConstraint = new RectangleConstraint(10.0, new Range(10.0, 10.0), LengthConstraintType.FIXED, 0.0, new Range(0.0, 0.0), LengthConstraintType.NONE);
        BlockContainer blockContainer = new BlockContainer(new BorderArrangement());
        BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        blockContainer.add(new EmptyBlock(5.0, 6.0));
        Size2D size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)6.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(15.0, 16.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(7.0, 20.0));
        blockContainer.add(new EmptyBlock(8.0, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(5.4, 3.2), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0));
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)12.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3));
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(21.0, 12.3), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        blockContainer.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        blockContainer.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        blockContainer.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        blockContainer.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(9.0, 10.0));
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size2D.height, (double)1.0E-10);
        blockContainer.clear();
        size2D = blockContainer.arrange(graphics2D, rectangleConstraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size2D.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)0.0, (double)size2D.height, (double)1.0E-10);
    }
}

