/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockBorder;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class BlockBorderTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BlockBorderTests.class);
    }

    public BlockBorderTests(String string) {
        super(string);
    }

    public void testEquals() {
        BlockBorder blockBorder = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorder blockBorder2 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertTrue((boolean)blockBorder.equals(blockBorder2));
        BlockBorderTests.assertTrue((boolean)blockBorder2.equals(blockBorder2));
        blockBorder = new BlockBorder(new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertFalse((boolean)blockBorder.equals(blockBorder2));
        blockBorder2 = new BlockBorder(new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertTrue((boolean)blockBorder.equals(blockBorder2));
        blockBorder = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.blue);
        BlockBorderTests.assertFalse((boolean)blockBorder.equals(blockBorder2));
        blockBorder2 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.blue);
        BlockBorderTests.assertTrue((boolean)blockBorder.equals(blockBorder2));
    }

    public void testCloning() {
        BlockBorder blockBorder = new BlockBorder();
        BlockBorderTests.assertFalse((boolean)(blockBorder instanceof Cloneable));
    }

    public void testSerialization() {
        BlockBorder blockBorder = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        BlockBorder blockBorder2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(blockBorder);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            blockBorder2 = (BlockBorder)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            BlockBorderTests.fail((String)exception.toString());
        }
        BlockBorderTests.assertTrue((boolean)blockBorder.equals(blockBorder2));
    }
}

