/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.block.EntityBlockParams;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;

public class LabelBlock
extends AbstractBlock
implements Block {
    private String text;
    private TextBlock label;
    private Font font;
    private String toolTipText;
    private String urlText;

    public LabelBlock(String string) {
        this(string, new Font("SansSerif", 0, 10));
    }

    public LabelBlock(String string, Font font) {
        this.text = string;
        this.label = TextUtilities.createTextBlock(string, font, Color.black);
        this.font = font;
        this.toolTipText = null;
        this.urlText = null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.label = TextUtilities.createTextBlock(this.text, font, Color.black);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        graphics2D.setFont(this.font);
        Size2D size2D = this.label.calculateDimensions(graphics2D);
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        EntityBlockParams entityBlockParams = null;
        StandardEntityCollection standardEntityCollection = null;
        Shape shape = null;
        if (object instanceof EntityBlockParams && (entityBlockParams = (EntityBlockParams)object).getGenerateEntities()) {
            standardEntityCollection = new StandardEntityCollection();
            shape = graphics2D.getTransform().createTransformedShape(rectangle2D);
        }
        graphics2D.setPaint(Color.black);
        graphics2D.setFont(this.font);
        this.label.draw(graphics2D, (float)rectangle2D.getX(), (float)rectangle2D.getY(), TextBlockAnchor.TOP_LEFT);
        BlockResult blockResult = null;
        if (entityBlockParams != null && standardEntityCollection != null && (this.toolTipText != null || this.urlText != null)) {
            ChartEntity chartEntity = new ChartEntity(shape, this.toolTipText, this.urlText);
            standardEntityCollection.add(chartEntity);
            blockResult = new BlockResult();
            blockResult.setEntityCollection(standardEntityCollection);
        }
        return blockResult;
    }
}

