/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ValueAxisTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(ValueAxisTests.class);
    }

    public ValueAxisTests(String string) {
        super(string);
    }

    public void testCloning() {
        NumberAxis numberAxis = new NumberAxis("Test");
        NumberAxis numberAxis2 = null;
        try {
            numberAxis2 = (NumberAxis)((ValueAxis)numberAxis).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("ValueAxisTests.testCloning: failed to clone.");
        }
        ValueAxisTests.assertTrue((numberAxis != numberAxis2 ? 1 : 0) != 0);
        ValueAxisTests.assertTrue((numberAxis.getClass() == numberAxis2.getClass() ? 1 : 0) != 0);
        ValueAxisTests.assertTrue((boolean)((ValueAxis)numberAxis).equals(numberAxis2));
    }

    public void testEquals() {
        NumberAxis numberAxis = new NumberAxis("Test");
        NumberAxis numberAxis2 = new NumberAxis("Test");
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAxisLineVisible(false);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAxisLineVisible(false);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setPositiveArrowVisible(true);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setPositiveArrowVisible(true);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setNegativeArrowVisible(true);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setNegativeArrowVisible(true);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAxisLinePaint(Color.blue);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAxisLinePaint(Color.blue);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        numberAxis.setAxisLineStroke(basicStroke);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAxisLineStroke(basicStroke);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setInverted(true);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setInverted(true);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setRange(new Range(50.0, 75.0));
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setRange(new Range(50.0, 75.0));
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAutoRange(true);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAutoRange(true);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAutoRangeMinimumSize(3.33);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAutoRangeMinimumSize(3.33);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setUpperMargin(0.09);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setUpperMargin(0.09);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setLowerMargin(0.09);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setLowerMargin(0.09);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setFixedAutoRange(50.0);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setFixedAutoRange(50.0);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAutoTickUnitSelection(false);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAutoTickUnitSelection(false);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setVerticalTickLabels(true);
        ValueAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setVerticalTickLabels(true);
        ValueAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
    }

    public void testAxisMargins() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        xYSeries.add(100.0, 1.1);
        xYSeries.add(200.0, 2.2);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        xYSeriesCollection.setIntervalWidth(0.0);
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("Title", "X", "Y", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        ValueAxis valueAxis = jFreeChart.getXYPlot().getDomainAxis();
        Range range = valueAxis.getRange();
        ValueAxisTests.assertEquals((double)110.0, (double)range.getLength(), (double)1.0E-9);
        valueAxis.setLowerMargin(0.1);
        valueAxis.setUpperMargin(0.1);
        range = valueAxis.getRange();
        ValueAxisTests.assertEquals((double)120.0, (double)range.getLength(), (double)1.0E-9);
    }
}

