/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.QuarterDateFormat;

public class QuarterDateFormatTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(QuarterDateFormatTests.class);
    }

    public QuarterDateFormatTests(String string) {
        super(string);
    }

    public void testEquals() {
        QuarterDateFormat quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat quarterDateFormat2 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat2.equals(quarterDateFormat));
        quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertFalse((boolean)quarterDateFormat.equals(quarterDateFormat2));
        quarterDateFormat2 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
        quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"A", "2", "3", "4"});
        QuarterDateFormatTests.assertFalse((boolean)quarterDateFormat.equals(quarterDateFormat2));
        quarterDateFormat2 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"A", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
    }

    public void testHashCode() {
        QuarterDateFormat quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat quarterDateFormat2 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
        int n = quarterDateFormat.hashCode();
        int n2 = quarterDateFormat2.hashCode();
        QuarterDateFormatTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        QuarterDateFormat quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat quarterDateFormat2 = null;
        quarterDateFormat2 = (QuarterDateFormat)quarterDateFormat.clone();
        QuarterDateFormatTests.assertTrue((quarterDateFormat != quarterDateFormat2 ? 1 : 0) != 0);
        QuarterDateFormatTests.assertTrue((quarterDateFormat.getClass() == quarterDateFormat2.getClass() ? 1 : 0) != 0);
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
    }

    public void testSerialization() {
        QuarterDateFormat quarterDateFormat = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat quarterDateFormat2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(quarterDateFormat);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            quarterDateFormat2 = (QuarterDateFormat)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            QuarterDateFormatTests.fail((String)exception.toString());
        }
        QuarterDateFormatTests.assertTrue((boolean)quarterDateFormat.equals(quarterDateFormat2));
    }
}

