/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Day;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.Year;

public class PeriodAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PeriodAxisTests.class);
    }

    public PeriodAxisTests(String string) {
        super(string);
    }

    public void testEquals() {
        PeriodAxis periodAxis = new PeriodAxis("Test");
        PeriodAxis periodAxis2 = new PeriodAxis("Test");
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        PeriodAxisTests.assertTrue((boolean)periodAxis2.equals(periodAxis));
        periodAxis.setFirst(new Year(2000));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setFirst(new Year(2000));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setLast(new Year(2004));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setLast(new Year(2004));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setAutoRangeTimePeriodClass(Quarter.class);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setAutoRangeTimePeriodClass(Quarter.class);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Month.class, new SimpleDateFormat("MMM"))};
        periodAxis.setLabelInfo(periodAxisLabelInfoArray);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setLabelInfo(periodAxisLabelInfoArray);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setMajorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setMajorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setMinorTickMarksVisible(!periodAxis.isMinorTickMarksVisible());
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setMinorTickMarksVisible(periodAxis.isMinorTickMarksVisible());
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setMinorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setMinorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        BasicStroke basicStroke = new BasicStroke(1.23f);
        periodAxis.setMinorTickMarkStroke(basicStroke);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setMinorTickMarkStroke(basicStroke);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setMinorTickMarkPaint(Color.blue);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setMinorTickMarkPaint(Color.blue);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
    }

    public void testHashCode() {
        PeriodAxis periodAxis = new PeriodAxis("Test");
        PeriodAxis periodAxis2 = new PeriodAxis("Test");
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        int n = periodAxis.hashCode();
        int n2 = periodAxis2.hashCode();
        PeriodAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        PeriodAxis periodAxis = new PeriodAxis("Test");
        PeriodAxis periodAxis2 = null;
        try {
            periodAxis2 = (PeriodAxis)periodAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        PeriodAxisTests.assertTrue((periodAxis != periodAxis2 ? 1 : 0) != 0);
        PeriodAxisTests.assertTrue((periodAxis.getClass() == periodAxis2.getClass() ? 1 : 0) != 0);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setLabel("New Label");
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setLabel("New Label");
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setFirst(new Year(1920));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setFirst(new Year(1920));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setLast(new Year(2020));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setLast(new Year(2020));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d")), new PeriodAxisLabelInfo(Year.class, new SimpleDateFormat("yyyy"))};
        periodAxis.setLabelInfo(periodAxisLabelInfoArray);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setLabelInfo(periodAxisLabelInfoArray);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setAutoRangeTimePeriodClass(Second.class);
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setAutoRangeTimePeriodClass(Second.class);
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
        periodAxis.setTimeZone(new SimpleTimeZone(123, "Bogus"));
        PeriodAxisTests.assertFalse((boolean)periodAxis.equals(periodAxis2));
        periodAxis2.setTimeZone(new SimpleTimeZone(123, "Bogus"));
        PeriodAxisTests.assertTrue((boolean)periodAxis.equals(periodAxis2));
    }

    public void testSerialization() {
        PeriodAxis periodAxis = new PeriodAxis("Test Axis");
        PeriodAxis periodAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(periodAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            periodAxis2 = (PeriodAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = periodAxis.equals(periodAxis2);
        PeriodAxisTests.assertTrue((boolean)bl);
    }
}

