/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.data.time.DateRange;
import org.jfree.ui.RectangleEdge;

public class DateAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DateAxisTests.class);
    }

    public DateAxisTests(String string) {
        super(string);
    }

    public void testEquals() {
        DateAxis dateAxis = new DateAxis("Test");
        DateAxis dateAxis2 = new DateAxis("Test");
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
        dateAxis.setTickUnit(new DateTickUnit(2, 7));
        DateAxisTests.assertFalse((boolean)dateAxis.equals(dateAxis2));
        dateAxis2.setTickUnit(new DateTickUnit(2, 7));
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
        dateAxis.setDateFormatOverride(new SimpleDateFormat("yyyy"));
        DateAxisTests.assertFalse((boolean)dateAxis.equals(dateAxis2));
        dateAxis2.setDateFormatOverride(new SimpleDateFormat("yyyy"));
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
        dateAxis.setTickMarkPosition(DateTickMarkPosition.END);
        DateAxisTests.assertFalse((boolean)dateAxis.equals(dateAxis2));
        dateAxis2.setTickMarkPosition(DateTickMarkPosition.END);
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
        dateAxis.setTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        DateAxisTests.assertFalse((boolean)dateAxis.equals(dateAxis2));
        dateAxis2.setTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
    }

    public void testHashCode() {
        DateAxis dateAxis = new DateAxis("Test");
        DateAxis dateAxis2 = new DateAxis("Test");
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
        int n = dateAxis.hashCode();
        int n2 = dateAxis2.hashCode();
        DateAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        DateAxis dateAxis = new DateAxis("Test");
        DateAxis dateAxis2 = null;
        try {
            dateAxis2 = (DateAxis)dateAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DateAxisTests.assertTrue((dateAxis != dateAxis2 ? 1 : 0) != 0);
        DateAxisTests.assertTrue((dateAxis.getClass() == dateAxis2.getClass() ? 1 : 0) != 0);
        DateAxisTests.assertTrue((boolean)dateAxis.equals(dateAxis2));
    }

    public void testSetRange() {
        DateAxis dateAxis = new DateAxis("Test Axis");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1999, 0, 3);
        Date date = calendar.getTime();
        calendar.set(1999, 0, 31);
        Date date2 = calendar.getTime();
        dateAxis.setRange(date, date2);
        DateRange dateRange = (DateRange)dateAxis.getRange();
        DateAxisTests.assertEquals((Object)date, (Object)dateRange.getLowerDate());
        DateAxisTests.assertEquals((Object)date2, (Object)dateRange.getUpperDate());
    }

    public void testSetMaximumDate() {
        DateAxis dateAxis = new DateAxis("Test Axis");
        Date date = new Date();
        dateAxis.setMaximumDate(date);
        DateAxisTests.assertEquals((Object)date, (Object)dateAxis.getMaximumDate());
    }

    public void testSetMinimumDate() {
        DateAxis dateAxis = new DateAxis("Test Axis");
        Date date = new Date();
        Date date2 = new Date(date.getTime() + 1L);
        dateAxis.setMaximumDate(date2);
        dateAxis.setMinimumDate(date);
        DateAxisTests.assertEquals((Object)date, (Object)dateAxis.getMinimumDate());
    }

    private boolean same(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public void testJava2DToValue() {
        DateAxis dateAxis = new DateAxis();
        dateAxis.setRange(50.0, 100.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(10.0, 50.0, 400.0, 300.0);
        double d = dateAxis.java2DToValue(75.0, double_, RectangleEdge.LEFT);
        DateAxisTests.assertTrue((boolean)this.same(d, 95.8333333, 1.0));
        double d2 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.RIGHT);
        DateAxisTests.assertTrue((boolean)this.same(d2, 95.8333333, 1.0));
        double d3 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.TOP);
        DateAxisTests.assertTrue((boolean)this.same(d3, 58.125, 1.0));
        double d4 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.BOTTOM);
        DateAxisTests.assertTrue((boolean)this.same(d4, 58.125, 1.0));
        dateAxis.setInverted(true);
        double d5 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.LEFT);
        DateAxisTests.assertTrue((boolean)this.same(d5, 54.1666667, 1.0));
        double d6 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.RIGHT);
        DateAxisTests.assertTrue((boolean)this.same(d6, 54.1666667, 1.0));
        double d7 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.TOP);
        DateAxisTests.assertTrue((boolean)this.same(d7, 91.875, 1.0));
        double d8 = dateAxis.java2DToValue(75.0, double_, RectangleEdge.BOTTOM);
        DateAxisTests.assertTrue((boolean)this.same(d8, 91.875, 1.0));
    }

    public void testSerialization() {
        DateAxis dateAxis = new DateAxis("Test Axis");
        DateAxis dateAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(dateAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            dateAxis2 = (DateAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = dateAxis.equals(dateAxis2);
        DateAxisTests.assertTrue((boolean)bl);
    }
}

