/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.ui.GreyPalette;

public class ColorBarTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ColorBarTests.class);
    }

    public ColorBarTests(String string) {
        super(string);
    }

    public void testEquals() {
        ColorBar colorBar = new ColorBar("Test");
        ColorBar colorBar2 = new ColorBar("Test");
        ColorBarTests.assertEquals((Object)colorBar, (Object)colorBar2);
        colorBar.setAxis(new NumberAxis("Axis 1"));
        ColorBarTests.assertTrue((!colorBar.equals(colorBar2) ? 1 : 0) != 0);
        colorBar2.setAxis(new NumberAxis("Axis 1"));
        ColorBarTests.assertTrue((boolean)colorBar.equals(colorBar2));
        colorBar.setColorPalette(new GreyPalette());
        ColorBarTests.assertTrue((!colorBar.equals(colorBar2) ? 1 : 0) != 0);
        colorBar2.setColorPalette(new GreyPalette());
        ColorBarTests.assertTrue((boolean)colorBar.equals(colorBar2));
    }

    public void testHashCode() {
        ColorBar colorBar = new ColorBar("Test");
        ColorBar colorBar2 = new ColorBar("Test");
        ColorBarTests.assertTrue((boolean)colorBar.equals(colorBar2));
        int n = colorBar.hashCode();
        int n2 = colorBar2.hashCode();
        ColorBarTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        ColorBar colorBar = new ColorBar("Test");
        ColorBar colorBar2 = null;
        try {
            colorBar2 = (ColorBar)colorBar.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        ColorBarTests.assertTrue((colorBar != colorBar2 ? 1 : 0) != 0);
        ColorBarTests.assertTrue((colorBar.getClass() == colorBar2.getClass() ? 1 : 0) != 0);
        ColorBarTests.assertTrue((boolean)colorBar.equals(colorBar2));
    }

    public void testSerialization() {
        ColorBar colorBar = new ColorBar("Test Axis");
        ColorBar colorBar2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(colorBar);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            colorBar2 = (ColorBar)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        ColorBarTests.assertEquals((Object)colorBar, colorBar2);
    }
}

