/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.NumberTickUnit;

public class SymbolicTickUnit
extends NumberTickUnit
implements Serializable {
    private static final long serialVersionUID = -4836679837074745805L;
    private String[] symbolicValue;

    public SymbolicTickUnit(double d, String[] stringArray) {
        super(d, null);
        this.symbolicValue = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.symbolicValue, 0, stringArray.length);
    }

    public String valueToString(double d) {
        if (d < 0.0 || d >= (double)this.symbolicValue.length) {
            throw new IllegalArgumentException("The value " + d + " does not have a corresponding symbolic value");
        }
        return this.symbolicValue[(int)d];
    }

    public int getSymbolCount() {
        return this.symbolicValue.length;
    }
}

