/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYShapeAnnotation;

public class XYShapeAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYShapeAnnotationTests.class);
    }

    public XYShapeAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYShapeAnnotation xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation2.equals(xYShapeAnnotation));
        xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.yellow);
        XYShapeAnnotationTests.assertFalse((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.yellow);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
    }

    public void testHashCode() {
        XYShapeAnnotation xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation xYShapeAnnotation2 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
        int n = xYShapeAnnotation.hashCode();
        int n2 = xYShapeAnnotation2.hashCode();
        XYShapeAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYShapeAnnotation xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation xYShapeAnnotation2 = null;
        try {
            xYShapeAnnotation2 = (XYShapeAnnotation)xYShapeAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYShapeAnnotationTests.assertTrue((xYShapeAnnotation != xYShapeAnnotation2 ? 1 : 0) != 0);
        XYShapeAnnotationTests.assertTrue((xYShapeAnnotation.getClass() == xYShapeAnnotation2.getClass() ? 1 : 0) != 0);
        XYShapeAnnotationTests.assertTrue((boolean)xYShapeAnnotation.equals(xYShapeAnnotation2));
    }

    public void testSerialization() {
        XYShapeAnnotation xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation xYShapeAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYShapeAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYShapeAnnotation2 = (XYShapeAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYShapeAnnotationTests.assertEquals((Object)xYShapeAnnotation, xYShapeAnnotation2);
    }
}

