/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendRenderingOrder;
import org.jfree.chart.OldLegend;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class DefaultOldLegend
extends OldLegend
implements Serializable {
    private static final long serialVersionUID = -5466149184220837922L;
    public static final RectangleInsets DEFAULT_MARGIN = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
    public static final RectangleInsets DEFAULT_PADDING = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke();
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 11);
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 10);
    public static final double NO_PREFERRED_WIDTH = Double.MAX_VALUE;
    private static final String UNEXPECTED_LEGEND_ANCHOR = "Unexpected legend anchor";
    private RectangleInsets margin;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private RectangleInsets padding;
    private String title = null;
    private Font titleFont;
    private Font itemFont;
    private transient Paint itemPaint;
    private double shapeScaleX = 1.0;
    private double shapeScaleY = 1.0;
    private LegendRenderingOrder renderingOrder = LegendRenderingOrder.STANDARD;
    private int boundingBoxArcWidth = 0;
    private int boundingBoxArcHeight = 0;
    private double preferredWidth = Double.MAX_VALUE;

    public DefaultOldLegend() {
        this.margin = DEFAULT_MARGIN;
        this.padding = DEFAULT_PADDING;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.titleFont = DEFAULT_TITLE_FONT;
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = Color.black;
    }

    public RectangleInsets getMargin() {
        return this.margin;
    }

    public void setMargin(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new NullPointerException("Null 'margin' argument.");
        }
        this.margin = rectangleInsets;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new NullPointerException("Null 'padding' argument.");
        }
        this.padding = rectangleInsets;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.titleFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleX() {
        return this.shapeScaleX;
    }

    public void setShapeScaleX(double d) {
        this.shapeScaleX = d;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleY() {
        return this.shapeScaleY;
    }

    public void setShapeScaleY(double d) {
        this.shapeScaleY = d;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public LegendRenderingOrder getRenderingOrder() {
        return this.renderingOrder;
    }

    public void setRenderingOrder(LegendRenderingOrder legendRenderingOrder) {
        if (legendRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = legendRenderingOrder;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcWidth() {
        return this.boundingBoxArcWidth;
    }

    public void setBoundingBoxArcWidth(int n) {
        this.boundingBoxArcWidth = n;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcHeight() {
        return this.boundingBoxArcHeight;
    }

    public void setBoundingBoxArcHeight(int n) {
        this.boundingBoxArcHeight = n;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(double d) {
        this.preferredWidth = d;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        return this.draw(graphics2D, rectangle2D, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0, chartRenderingInfo);
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2, ChartRenderingInfo chartRenderingInfo) {
        Point2D point2D;
        RoundRectangle2D roundRectangle2D;
        LegendItemCollection legendItemCollection = this.getChart().getPlot().getLegendItems();
        if (legendItemCollection == null || legendItemCollection.getItemCount() == 0) {
            return rectangle2D;
        }
        DrawableLegendItem drawableLegendItem = null;
        LegendItem legendItem = null;
        if (this.title != null && !this.title.equals("")) {
            legendItem = new LegendItem(this.title, this.title, null, null, null, Color.black);
        }
        double d = rectangle2D.getWidth();
        ArrayList<DrawableLegendItem> arrayList = new ArrayList<DrawableLegendItem>();
        if (bl) {
            double d2 = rectangle2D.getX() + this.getMargin().calculateLeftOutset(d);
            double d3 = rectangle2D.getMaxX() - this.getMargin().calculateRightOutset(d);
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl3 = true;
            if (legendItem != null) {
                graphics2D.setFont(this.getTitleFont());
                drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, d5, d7);
                d6 = Math.max(0.0, drawableLegendItem.getHeight());
                d5 += drawableLegendItem.getWidth();
            }
            graphics2D.setFont(this.itemFont);
            for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
                DrawableLegendItem drawableLegendItem2 = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createDrawableLegendItem(graphics2D, legendItemCollection.get(i), d5, d7) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createDrawableLegendItem(graphics2D, legendItemCollection.get(legendItemCollection.getItemCount() - i - 1), d5, d7) : null);
                if (drawableLegendItem2.getMaxX() + d2 > d3 && bl3) {
                    d4 = Math.max(d4, d5);
                    d5 = 0.0;
                    d7 += d6;
                    --i;
                    bl3 = false;
                    continue;
                }
                d6 = Math.max(d6, drawableLegendItem2.getHeight());
                d5 += drawableLegendItem2.getWidth();
                bl3 = true;
                arrayList.add(drawableLegendItem2);
            }
            d4 = Math.max(d4, d5);
            roundRectangle2D = new RoundRectangle2D.Double(0.0, 0.0, d4, d7 += d6, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            point2D = this.createTranslationPointForHorizontalDraw(rectangle2D, bl2, d4, d7);
        } else {
            double d8;
            double d9 = 0.0;
            double d10 = d8 = this.preferredWidth == Double.MAX_VALUE ? 0.0 : this.preferredWidth;
            if (legendItem != null) {
                graphics2D.setFont(this.getTitleFont());
                drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, 0.0, d9);
                d9 += drawableLegendItem.getHeight();
                d8 = Math.max(d8, drawableLegendItem.getWidth());
            }
            graphics2D.setFont(this.itemFont);
            int n = legendItemCollection.getItemCount();
            for (int i = 0; i < n; ++i) {
                List list = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createAllDrawableLinesForItem(graphics2D, legendItemCollection.get(i), 0.0, d9, d8) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createAllDrawableLinesForItem(graphics2D, legendItemCollection.get(n - i - 1), 0.0, d9, d8) : null);
                for (DrawableLegendItem drawableLegendItem3 : list) {
                    d9 += drawableLegendItem3.getHeight();
                    d8 = Math.max(d8, drawableLegendItem3.getWidth());
                    arrayList.add(drawableLegendItem3);
                }
            }
            roundRectangle2D = new RoundRectangle2D.Float(0.0f, 0.0f, (float)d8, (float)d9, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            point2D = this.createTranslationPointForVerticalDraw(rectangle2D, bl2, d9, d8);
        }
        graphics2D.translate(point2D.getX(), point2D.getY());
        this.drawLegendBox(graphics2D, roundRectangle2D);
        this.drawLegendTitle(graphics2D, drawableLegendItem);
        this.drawSeriesElements(graphics2D, arrayList, point2D, chartRenderingInfo);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
        return this.calcRemainingDrawingArea(rectangle2D, bl, bl2, roundRectangle2D);
    }

    private Point2D createTranslationPointForHorizontalDraw(Rectangle2D rectangle2D, boolean bl, double d, double d2) {
        double d3;
        double d4;
        double d5 = d4 = bl ? rectangle2D.getMaxY() - d2 - this.getMargin().calculateBottomOutset(rectangle2D.getHeight()) : rectangle2D.getY() + this.getMargin().calculateTopOutset(rectangle2D.getHeight());
        if (this.isAnchoredToLeft()) {
            d3 = rectangle2D.getX() + this.getMargin().calculateLeftOutset(rectangle2D.getWidth());
        } else if (this.isAnchoredToCenter()) {
            d3 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d / 2.0;
        } else if (this.isAnchoredToRight()) {
            d3 = rectangle2D.getX() + rectangle2D.getWidth() - d - this.getChart().getPlot().getInsets().getLeft();
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double(d3, d4);
    }

    private Point2D createTranslationPointForVerticalDraw(Rectangle2D rectangle2D, boolean bl, double d, double d2) {
        double d3;
        double d4;
        double d5 = d4 = bl ? rectangle2D.getMaxX() - d2 - this.getMargin().calculateRightOutset(rectangle2D.getWidth()) : rectangle2D.getX() + this.getMargin().calculateLeftOutset(rectangle2D.getWidth());
        if (this.isAnchoredToTop()) {
            d3 = rectangle2D.getY() + this.getChart().getPlot().getInsets().getTop();
        } else if (this.isAnchoredToMiddle()) {
            d3 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d / 2.0;
        } else if (this.isAnchoredToBottom()) {
            d3 = rectangle2D.getY() + rectangle2D.getHeight() - this.getChart().getPlot().getInsets().getBottom() - d;
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double(d4, d3);
    }

    private void drawLegendTitle(Graphics2D graphics2D, DrawableLegendItem drawableLegendItem) {
        if (drawableLegendItem != null) {
            graphics2D.setPaint(drawableLegendItem.getItem().getFillPaint());
            graphics2D.setPaint(this.itemPaint);
            graphics2D.setFont(this.getTitleFont());
            TextUtilities.drawAlignedString(drawableLegendItem.getItem().getLabel(), graphics2D, (float)drawableLegendItem.getLabelPosition().getX(), (float)drawableLegendItem.getLabelPosition().getY(), TextAnchor.CENTER_LEFT);
        }
    }

    private void drawLegendBox(Graphics2D graphics2D, RectangularShape rectangularShape) {
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fill(rectangularShape);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.draw(rectangularShape);
    }

    private void drawSeriesElements(Graphics2D graphics2D, List list, Point2D point2D, ChartRenderingInfo chartRenderingInfo) {
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        for (int i = 0; i < list.size(); ++i) {
            DrawableLegendItem drawableLegendItem = (DrawableLegendItem)list.get(i);
            graphics2D.setPaint(drawableLegendItem.getItem().getFillPaint());
            Shape shape = drawableLegendItem.getMarker();
            if (drawableLegendItem.getItem().isLineVisible()) {
                graphics2D.setStroke(drawableLegendItem.getItem().getLineStroke());
                graphics2D.draw(drawableLegendItem.getLine());
                if (drawableLegendItem.getItem().isShapeVisible()) {
                    if (drawableLegendItem.getItem().isShapeFilled()) {
                        graphics2D.fill(shape);
                    } else {
                        graphics2D.draw(shape);
                    }
                }
            } else {
                if (drawableLegendItem.getItem().isShapeFilled()) {
                    graphics2D.fill(shape);
                }
                if (drawableLegendItem.getItem().isShapeOutlineVisible()) {
                    graphics2D.setPaint(drawableLegendItem.getItem().getOutlinePaint());
                    graphics2D.setStroke(drawableLegendItem.getItem().getOutlineStroke());
                    graphics2D.draw(shape);
                }
            }
            graphics2D.setPaint(this.itemPaint);
            graphics2D.setFont(this.itemFont);
            TextUtilities.drawAlignedString(drawableLegendItem.getItem().getLabel(), graphics2D, (float)drawableLegendItem.getLabelPosition().getX(), (float)drawableLegendItem.getLabelPosition().getY(), TextAnchor.CENTER_LEFT);
            if (entityCollection == null) continue;
            Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() + drawableLegendItem.getX(), point2D.getY() + drawableLegendItem.getY(), drawableLegendItem.getWidth(), drawableLegendItem.getHeight());
            LegendItemEntity legendItemEntity = new LegendItemEntity(double_);
            legendItemEntity.setSeriesIndex(i);
            entityCollection.add(legendItemEntity);
        }
    }

    private Rectangle2D calcRemainingDrawingArea(Rectangle2D rectangle2D, boolean bl, boolean bl2, RectangularShape rectangularShape) {
        if (bl) {
            double d = rectangle2D.getY();
            double d2 = bl2 ? d : d + rectangularShape.getHeight() + this.getMargin().calculateBottomOutset(rectangle2D.getHeight());
            return new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), rectangle2D.getHeight() - rectangularShape.getHeight() - this.getMargin().calculateTopOutset(rectangle2D.getHeight()) - this.getMargin().calculateBottomOutset(rectangle2D.getHeight()));
        }
        double d = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangularShape.getWidth() + this.getMargin().calculateLeftOutset(rectangle2D.getWidth()) + this.getMargin().calculateRightOutset(rectangle2D.getWidth());
        return new Rectangle2D.Double(d, rectangle2D.getY(), rectangle2D.getWidth() - rectangularShape.getWidth() - this.getMargin().calculateLeftOutset(rectangle2D.getWidth()) - this.getMargin().calculateRightOutset(rectangle2D.getWidth()), rectangle2D.getHeight());
    }

    private List createAllDrawableLinesForItem(Graphics2D graphics2D, LegendItem legendItem, double d, double d2, double d3) {
        ArrayList<DrawableLegendItem> arrayList = new ArrayList<DrawableLegendItem>();
        DrawableLegendItem drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, d, d2);
        if (drawableLegendItem.getWidth() < d3) {
            arrayList.add(drawableLegendItem);
            return arrayList;
        }
        boolean bl = true;
        double d4 = d2;
        String string = "";
        String string2 = legendItem.getLabel().trim();
        LegendItem legendItem2 = new LegendItem(string.trim(), legendItem.getLabel(), legendItem.getToolTipText(), legendItem.getURLText(), legendItem.isShapeVisible(), legendItem.getShape(), legendItem.isShapeFilled(), legendItem.getFillPaint(), legendItem.isShapeOutlineVisible(), legendItem.getOutlinePaint(), legendItem.getOutlineStroke(), legendItem.isLineVisible(), legendItem.getLine(), legendItem.getLineStroke(), legendItem.getLinePaint());
        drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem2, d, d4);
        DrawableLegendItem drawableLegendItem2 = null;
        do {
            String string3 = string2;
            int n = string2.indexOf(" ");
            if (n < 0) {
                string = string + string2;
                string2 = "";
            } else {
                string = string + string2.substring(0, n + 1);
                string2 = string2.substring(n + 1);
            }
            legendItem2 = new LegendItem(string.trim(), legendItem.getLabel(), legendItem.getToolTipText(), legendItem.getURLText(), bl && legendItem.isShapeVisible(), legendItem.getShape(), bl && legendItem.isShapeFilled(), legendItem.getFillPaint(), bl && legendItem.isShapeOutlineVisible(), legendItem.getOutlinePaint(), legendItem.getOutlineStroke(), bl && legendItem.isLineVisible(), legendItem.getLine(), legendItem.getLineStroke(), legendItem.getLinePaint());
            drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem2, d, d4);
            if (drawableLegendItem.getWidth() < d3) {
                drawableLegendItem2 = drawableLegendItem;
                continue;
            }
            if (drawableLegendItem2 == null) {
                arrayList.add(drawableLegendItem);
                d4 += drawableLegendItem.getHeight();
            } else {
                arrayList.add(drawableLegendItem2);
                d4 += drawableLegendItem2.getHeight();
                string2 = string3;
            }
            bl = false;
            string = "";
            string2 = string2.trim();
            drawableLegendItem = null;
            drawableLegendItem2 = null;
        } while (!string2.equals(""));
        if (drawableLegendItem != null) {
            arrayList.add(drawableLegendItem);
        }
        return arrayList;
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics2D, LegendItem legendItem, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(legendItem.getLabel(), graphics2D);
        float f = lineMetrics.getAscent();
        float f2 = f + lineMetrics.getDescent() + lineMetrics.getLeading();
        DrawableLegendItem drawableLegendItem = new DrawableLegendItem(legendItem);
        float f3 = (float)(d + (double)n + (double)(1.15f * f2));
        float f4 = (float)(d2 + (double)n + (double)(0.5f * f2));
        drawableLegendItem.setLabelPosition(new Point2D.Float(f3, f4));
        float f5 = (float)(drawableLegendItem.getLabelPosition().getX() - d + (double)fontMetrics.stringWidth(legendItem.getLabel()) + 0.5 * (double)f);
        float f6 = (float)(2 * n) + f2;
        drawableLegendItem.setBounds(d, d2, f5, f6);
        float f7 = f2 * 0.7f;
        float f8 = (float)(d + (double)n + (double)(0.15f * f2));
        float f9 = (float)(d2 + (double)n + (double)(0.15f * f2));
        if (legendItem.isLineVisible()) {
            Line2D.Float float_ = new Line2D.Float(f8, f9 + f7 / 2.0f, f8 + f7 * 3.0f, f9 + f7 / 2.0f);
            drawableLegendItem.setLine(float_);
            drawableLegendItem.setBounds(drawableLegendItem.getX(), drawableLegendItem.getY(), drawableLegendItem.getWidth() + (double)(f7 * 2.0f), drawableLegendItem.getHeight());
            drawableLegendItem.setLabelPosition(new Point2D.Float(f3 + f7 * 2.0f, f4));
            if (drawableLegendItem.getItem().isShapeVisible()) {
                Shape shape = legendItem.getShape();
                AffineTransform affineTransform = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
                Shape shape2 = affineTransform.createTransformedShape(shape);
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance((double)f8 + (double)f7 * 1.5, f9 + f7 / 2.0f);
                Shape shape3 = affineTransform2.createTransformedShape(shape2);
                drawableLegendItem.setMarker(shape3);
            }
        } else if (drawableLegendItem.getItem().isShapeVisible()) {
            Shape shape = legendItem.getShape();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
            Shape shape4 = affineTransform.createTransformedShape(shape);
            AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(f8 + f7 / 2.0f, f9 + f7 / 2.0f);
            Shape shape5 = affineTransform3.createTransformedShape(shape4);
            drawableLegendItem.setMarker(shape5);
        } else {
            drawableLegendItem.setMarker(new Rectangle2D.Float(f8, f9, f7, f7));
        }
        return drawableLegendItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultOldLegend)) {
            return false;
        }
        DefaultOldLegend defaultOldLegend = (DefaultOldLegend)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.margin, defaultOldLegend.margin)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, defaultOldLegend.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlinePaint, defaultOldLegend.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundPaint, defaultOldLegend.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.padding, defaultOldLegend.padding)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.title, defaultOldLegend.title)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.titleFont, defaultOldLegend.titleFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemFont, defaultOldLegend.itemFont)) {
            return false;
        }
        return ObjectUtilities.equal(this.itemPaint, defaultOldLegend.itemPaint);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.itemPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.itemPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

