/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class ChartRenderingInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2751952018173406822L;
    private transient Rectangle2D chartArea = new Rectangle2D.Double();
    private PlotRenderingInfo plotInfo;
    private transient Rectangle2D plotArea = new Rectangle2D.Double();
    private EntityCollection entities;

    public ChartRenderingInfo() {
        this(new StandardEntityCollection());
    }

    public ChartRenderingInfo(EntityCollection entityCollection) {
        this.plotInfo = new PlotRenderingInfo(this);
        this.entities = entityCollection;
    }

    public Rectangle2D getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(Rectangle2D rectangle2D) {
        this.chartArea.setRect(rectangle2D);
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(Rectangle2D rectangle2D) {
        this.plotArea.setRect(rectangle2D);
    }

    public EntityCollection getEntityCollection() {
        return this.entities;
    }

    public void setEntityCollection(EntityCollection entityCollection) {
        this.entities = entityCollection;
    }

    public void clear() {
        this.chartArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.plotArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.plotInfo = new PlotRenderingInfo(this);
        if (this.entities != null) {
            this.entities.clear();
        }
    }

    public PlotRenderingInfo getPlotInfo() {
        return this.plotInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartRenderingInfo) {
            ChartRenderingInfo chartRenderingInfo = (ChartRenderingInfo)object;
            return ObjectUtilities.equal(this.chartArea, chartRenderingInfo.chartArea);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.chartArea, objectOutputStream);
        SerialUtilities.writeShape(this.plotArea, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.chartArea = (Rectangle2D)SerialUtilities.readShape(objectInputStream);
        this.plotArea = (Rectangle2D)SerialUtilities.readShape(objectInputStream);
    }
}

