/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketDisconnect;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportConnection;
import ch.ethz.ssh2.util.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class TransportManager {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$transport$TransportManager == null ? (class$ch$ethz$ssh2$transport$TransportManager = TransportManager.class$("ch.ethz.ssh2.transport.TransportManager")) : class$ch$ethz$ssh2$transport$TransportManager);
    private final Vector asynchronousQueue = new Vector();
    private Thread asynchronousThread = null;
    String hostname;
    int port;
    Socket sock;
    Object connectionSemaphore = new Object();
    boolean flagKexOngoing = false;
    boolean connectionClosed = false;
    Throwable reasonClosedCause = null;
    Vector kexBlockedSendQueue = new Vector(10);
    TransportConnection tc;
    KexManager km;
    Vector messageHandlers = new Vector();
    Thread receiveThread;
    static /* synthetic */ Class class$ch$ethz$ssh2$transport$TransportManager;

    private InetAddress createInetAddress(String string) throws UnknownHostException {
        InetAddress inetAddress = this.parseIPv4Address(string);
        if (inetAddress != null) {
            return inetAddress;
        }
        return InetAddress.getByName(string);
    }

    private InetAddress parseIPv4Address(String string) throws UnknownHostException {
        if (string == null) {
            return null;
        }
        String[] stringArray = Tokenizer.parseTokens(string, '.');
        if (stringArray == null || stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = 0;
            if (stringArray[i].length() == 0 || stringArray[i].length() > 3) {
                return null;
            }
            for (int j = 0; j < stringArray[i].length(); ++j) {
                char c = stringArray[i].charAt(j);
                if (c < '0' || c > '9') {
                    return null;
                }
                n = n * 10 + (c - 48);
            }
            if (n > 255) {
                return null;
            }
            byArray[i] = (byte)n;
        }
        return InetAddress.getByAddress(byArray);
    }

    public TransportManager(String string, int n) throws IOException {
        this.hostname = string;
        this.port = n;
        try {
            InetAddress inetAddress = this.createInetAddress(string);
            this.sock = new Socket(inetAddress, n);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Cannot establish TCP connection to " + string + ":" + n).initCause(iOException);
        }
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream());
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public void setTcpNoDelay(boolean bl) throws IOException {
        this.sock.setTcpNoDelay(bl);
    }

    public ConnectionInfo getConnectionInfo(int n) throws IOException {
        return this.km.getOrWaitForConnectionInfo(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable throwable, boolean bl) {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                return;
            }
            if (bl) {
                try {
                    byte[] byArray = new PacketDisconnect(11, throwable.getMessage(), "").getPayload();
                    this.tc.sendMessage(byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connectionClosed = true;
            this.reasonClosedCause = throwable;
            this.connectionSemaphore.notifyAll();
        }
    }

    public void initialize(CryptoWishList cryptoWishList, ServerHostKeyVerifier serverHostKeyVerifier, DHGexParameters dHGexParameters) throws IOException {
        ClientServerHello clientServerHello = new ClientServerHello(this.sock.getInputStream(), this.sock.getOutputStream());
        this.km = new KexManager(this, clientServerHello, cryptoWishList, this.hostname, this.port, serverHostKeyVerifier);
        this.km.initiateKEX(cryptoWishList, dHGexParameters);
        this.receiveThread = new Thread(new Runnable(){

            public void run() {
                block9: {
                    try {
                        TransportManager.this.receiveLoop();
                    }
                    catch (IOException iOException) {
                        TransportManager.this.close(iOException, false);
                        if (!log.isEnabled()) break block9;
                        log.log(10, "Receive thread: error in receiveLoop: " + iOException.getMessage());
                    }
                }
                if (log.isEnabled()) {
                    log.log(50, "Receive thread: back from receiveLoop");
                }
                if (TransportManager.this.km != null) {
                    try {
                        TransportManager.this.km.handleMessage(null, 0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < TransportManager.this.messageHandlers.size(); ++i) {
                    HandlerEntry handlerEntry = (HandlerEntry)TransportManager.this.messageHandlers.elementAt(i);
                    try {
                        handlerEntry.mh.handleMessage(null, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler messageHandler, int n, int n2) {
        HandlerEntry handlerEntry = new HandlerEntry();
        handlerEntry.mh = messageHandler;
        handlerEntry.low = n;
        handlerEntry.high = n2;
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            this.messageHandlers.addElement(handlerEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler messageHandler, int n, int n2) {
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry handlerEntry = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (handlerEntry.mh != messageHandler || handlerEntry.low != n || handlerEntry.high != n2) continue;
                this.messageHandlers.removeElementAt(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] byArray) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(byArray);
            }
            catch (IOException iOException) {
                this.close(iOException, false);
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            for (int i = 0; i < this.kexBlockedSendQueue.size(); ++i) {
                this.tc.sendMessage((byte[])this.kexBlockedSendQueue.elementAt(i));
            }
            this.connectionSemaphore.notifyAll();
        }
    }

    public void forceKeyExchange(CryptoWishList cryptoWishList, DHGexParameters dHGexParameters) throws IOException {
        this.km.initiateKEX(cryptoWishList, dHGexParameters);
    }

    public void changeRecvCipher(BlockCipher blockCipher, MAC mAC) {
        this.tc.changeRecvCipher(blockCipher, mAC);
    }

    public void changeSendCipher(BlockCipher blockCipher, MAC mAC) {
        this.tc.changeSendCipher(blockCipher, mAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] byArray) throws IOException {
        Vector vector = this.asynchronousQueue;
        synchronized (vector) {
            this.asynchronousQueue.addElement(byArray);
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new AsynchronousWorker();
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] byArray) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            while (true) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) break;
                if (Thread.currentThread() == this.receiveThread) {
                    this.kexBlockedSendQueue.addElement(byArray);
                    return;
                }
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.tc.sendMessage(byArray);
            }
            catch (IOException iOException) {
                this.close(iOException, false);
                throw iOException;
            }
        }
    }

    public void receiveLoop() throws IOException {
        byte[] byArray = new byte[35000];
        while (true) {
            int n;
            Object object;
            int n2 = this.tc.receiveMessage(byArray, 0, byArray.length);
            int n3 = byArray[0] & 0xFF;
            if (n3 == 2) continue;
            if (n3 == 4) {
                if (!log.isEnabled()) continue;
                object = new TypesReader(byArray, 0, n2);
                ((TypesReader)object).readByte();
                ((TypesReader)object).readBoolean();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(((TypesReader)object).readString("UTF-8"));
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    n = stringBuffer.charAt(i);
                    if (n >= 32 && n <= 126) continue;
                    stringBuffer.setCharAt(i, '\ufffd');
                }
                log.log(50, "DEBUG Message from remote: '" + stringBuffer.toString() + "'");
                continue;
            }
            if (n3 == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (n3 == 1) {
                object = new TypesReader(byArray, 0, n2);
                ((TypesReader)object).readByte();
                int n4 = ((TypesReader)object).readUINT32();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(((TypesReader)object).readString("UTF-8"));
                if (stringBuffer.length() > 255) {
                    stringBuffer.setLength(255);
                    stringBuffer.setCharAt(254, '.');
                    stringBuffer.setCharAt(253, '.');
                    stringBuffer.setCharAt(252, '.');
                }
                for (n = 0; n < stringBuffer.length(); ++n) {
                    char c = stringBuffer.charAt(n);
                    if (c >= ' ' && c <= '~') continue;
                    stringBuffer.setCharAt(n, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + n4 + "): " + stringBuffer.toString());
            }
            if (n3 == 20 || n3 == 21 || n3 >= 30 && n3 <= 49) {
                this.km.handleMessage(byArray, n2);
                continue;
            }
            object = null;
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry handlerEntry = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (handlerEntry.low > n3 || n3 > handlerEntry.high) continue;
                object = handlerEntry.mh;
                break;
            }
            if (object == null) {
                throw new IOException("Unexpected SSH message (type " + n3 + ")");
            }
            object.handleMessage(byArray, n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AsynchronousWorker
    extends Thread {
        AsynchronousWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] byArray = null;
                Vector vector = TransportManager.this.asynchronousQueue;
                synchronized (vector) {
                    if (TransportManager.this.asynchronousQueue.size() == 0) {
                        try {
                            TransportManager.this.asynchronousQueue.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TransportManager.this.asynchronousQueue.size() == 0) {
                            TransportManager.this.asynchronousThread = null;
                            return;
                        }
                    }
                    byArray = (byte[])TransportManager.this.asynchronousQueue.remove(0);
                }
                try {
                    TransportManager.this.sendMessage(byArray);
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
    }

    class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        HandlerEntry() {
        }
    }
}

