/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CipherInputStream;
import ch.ethz.ssh2.crypto.cipher.CipherOutputStream;
import ch.ethz.ssh2.crypto.cipher.NullCipher;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.Packets;
import ch.ethz.ssh2.transport.ClientServerHello;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class TransportConnection {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$transport$TransportConnection == null ? (class$ch$ethz$ssh2$transport$TransportConnection = TransportConnection.class$("ch.ethz.ssh2.transport.TransportConnection")) : class$ch$ethz$ssh2$transport$TransportConnection);
    int send_seq_number = 0;
    int recv_seq_number = 0;
    CipherInputStream cis;
    CipherOutputStream cos;
    boolean useRandomPadding = false;
    MAC send_mac;
    byte[] send_mac_buffer;
    int send_padd_blocksize = 8;
    MAC recv_mac;
    byte[] recv_mac_buffer;
    byte[] recv_mac_buffer_cmp;
    int recv_padd_blocksize = 8;
    final byte[] send_padding_buffer = new byte[256];
    final byte[] send_packet_header_buffer = new byte[5];
    final byte[] recv_padding_buffer = new byte[256];
    final byte[] recv_packet_header_buffer = new byte[5];
    boolean recv_packet_header_present = false;
    ClientServerHello csh;
    final SecureRandom rnd = new SecureRandom();
    static /* synthetic */ Class class$ch$ethz$ssh2$transport$TransportConnection;

    public TransportConnection(InputStream inputStream, OutputStream outputStream) {
        this.cis = new CipherInputStream(new NullCipher(), inputStream);
        this.cos = new CipherOutputStream(new NullCipher(), outputStream);
    }

    public void changeRecvCipher(BlockCipher blockCipher, MAC mAC) {
        this.cis.changeCipher(blockCipher);
        this.recv_mac = mAC;
        this.recv_mac_buffer = mAC != null ? new byte[mAC.size()] : null;
        this.recv_mac_buffer_cmp = mAC != null ? new byte[mAC.size()] : null;
        this.recv_padd_blocksize = blockCipher.getBlockSize();
        if (this.recv_padd_blocksize < 8) {
            this.recv_padd_blocksize = 8;
        }
    }

    public void changeSendCipher(BlockCipher blockCipher, MAC mAC) {
        if (!(blockCipher instanceof NullCipher)) {
            this.useRandomPadding = true;
        }
        this.cos.changeCipher(blockCipher);
        this.send_mac = mAC;
        this.send_mac_buffer = mAC != null ? new byte[mAC.size()] : null;
        this.send_padd_blocksize = blockCipher.getBlockSize();
        if (this.send_padd_blocksize < 8) {
            this.send_padd_blocksize = 8;
        }
    }

    public void sendMessage(byte[] byArray) throws IOException {
        this.sendMessage(byArray, 0, byArray.length, 0);
    }

    public void sendMessage(byte[] byArray, int n, int n2) throws IOException {
        this.sendMessage(byArray, n, n2, 0);
    }

    public int getPacketOverheadEstimate() {
        return 9 + (this.send_padd_blocksize - 1) + this.send_mac_buffer.length;
    }

    public void sendMessage(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (n3 < 4) {
            n3 = 4;
        } else if (n3 > 64) {
            n3 = 64;
        }
        int n4 = 5 + n2 + n3;
        int n5 = n4 % this.send_padd_blocksize;
        if (n5 != 0) {
            n4 += this.send_padd_blocksize - n5;
        }
        if (n4 < 16) {
            n4 = 16;
        }
        int n6 = n4 - (5 + n2);
        if (this.useRandomPadding) {
            for (int i = 0; i < n6; i += 4) {
                int n7 = this.rnd.nextInt();
                this.send_padding_buffer[i] = (byte)n7;
                this.send_padding_buffer[i + 1] = (byte)(n7 >> 8);
                this.send_padding_buffer[i + 2] = (byte)(n7 >> 16);
                this.send_padding_buffer[i + 3] = (byte)(n7 >> 24);
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                this.send_padding_buffer[i] = 0;
            }
        }
        this.send_packet_header_buffer[0] = (byte)(n4 - 4 >> 24);
        this.send_packet_header_buffer[1] = (byte)(n4 - 4 >> 16);
        this.send_packet_header_buffer[2] = (byte)(n4 - 4 >> 8);
        this.send_packet_header_buffer[3] = (byte)(n4 - 4);
        this.send_packet_header_buffer[4] = (byte)n6;
        this.cos.write(this.send_packet_header_buffer, 0, 5);
        this.cos.write(byArray, n, n2);
        this.cos.write(this.send_padding_buffer, 0, n6);
        if (this.send_mac != null) {
            this.send_mac.initMac(this.send_seq_number);
            this.send_mac.update(this.send_packet_header_buffer, 0, 5);
            this.send_mac.update(byArray, n, n2);
            this.send_mac.update(this.send_padding_buffer, 0, n6);
            this.send_mac.getMac(this.send_mac_buffer, 0);
            this.cos.writePlain(this.send_mac_buffer, 0, this.send_mac_buffer.length);
        }
        this.cos.flush();
        if (log.isEnabled()) {
            log.log(90, "Sent " + Packets.getMessageName(byArray[n] & 0xFF) + " " + n2 + " bytes payload");
        }
        ++this.send_seq_number;
    }

    public int peekNextMessageLength() throws IOException {
        if (!this.recv_packet_header_present) {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
            this.recv_packet_header_present = true;
        }
        int n = (this.recv_packet_header_buffer[0] & 0xFF) << 24 | (this.recv_packet_header_buffer[1] & 0xFF) << 16 | (this.recv_packet_header_buffer[2] & 0xFF) << 8 | this.recv_packet_header_buffer[3] & 0xFF;
        int n2 = this.recv_packet_header_buffer[4] & 0xFF;
        if (n > 35000 || n < 12) {
            throw new IOException("Illegal packet size! (" + n + ")");
        }
        int n3 = n - n2 - 1;
        if (n3 < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + n2 + ")");
        }
        return n3;
    }

    public int receiveMessage(byte[] byArray, int n, int n2) throws IOException {
        if (!this.recv_packet_header_present) {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
        } else {
            this.recv_packet_header_present = false;
        }
        int n3 = (this.recv_packet_header_buffer[0] & 0xFF) << 24 | (this.recv_packet_header_buffer[1] & 0xFF) << 16 | (this.recv_packet_header_buffer[2] & 0xFF) << 8 | this.recv_packet_header_buffer[3] & 0xFF;
        int n4 = this.recv_packet_header_buffer[4] & 0xFF;
        if (n3 > 35000 || n3 < 12) {
            throw new IOException("Illegal packet size! (" + n3 + ")");
        }
        int n5 = n3 - n4 - 1;
        if (n5 < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + n4 + ")");
        }
        if (n5 >= n2) {
            throw new IOException("Receive buffer too small (" + n2 + ", need " + n5 + ")");
        }
        this.cis.read(byArray, n, n5);
        this.cis.read(this.recv_padding_buffer, 0, n4);
        if (this.recv_mac != null) {
            this.cis.readPlain(this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            this.recv_mac.initMac(this.recv_seq_number);
            this.recv_mac.update(this.recv_packet_header_buffer, 0, 5);
            this.recv_mac.update(byArray, n, n5);
            this.recv_mac.update(this.recv_padding_buffer, 0, n4);
            this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
            for (int i = 0; i < this.recv_mac_buffer.length; ++i) {
                if (this.recv_mac_buffer[i] == this.recv_mac_buffer_cmp[i]) continue;
                throw new IOException("Remote sent corrupt MAC.");
            }
        }
        ++this.recv_seq_number;
        if (log.isEnabled()) {
            log.log(90, "Received " + Packets.getMessageName(byArray[n] & 0xFF) + " " + n5 + " bytes payload");
        }
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

