/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.KeyMaterial;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.dh.DhExchange;
import ch.ethz.ssh2.crypto.dh.DhGroupExchange;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketKexDHInit;
import ch.ethz.ssh2.packets.PacketKexDHReply;
import ch.ethz.ssh2.packets.PacketKexDhGexGroup;
import ch.ethz.ssh2.packets.PacketKexDhGexInit;
import ch.ethz.ssh2.packets.PacketKexDhGexReply;
import ch.ethz.ssh2.packets.PacketKexDhGexRequest;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.packets.PacketNewKeys;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexParameters;
import ch.ethz.ssh2.transport.KexState;
import ch.ethz.ssh2.transport.NegotiateException;
import ch.ethz.ssh2.transport.NegotiatedParameters;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;

public class KexManager {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$transport$KexManager == null ? (class$ch$ethz$ssh2$transport$KexManager = KexManager.class$("ch.ethz.ssh2.transport.KexManager")) : class$ch$ethz$ssh2$transport$KexManager);
    KexState kxs;
    int kexCount = 0;
    KeyMaterial km;
    byte[] sessionId;
    ClientServerHello csh;
    Object accessLock = new Object();
    ConnectionInfo lastConnInfo = null;
    boolean connectionClosed = false;
    boolean ignore_next_kex_packet = false;
    TransportManager tm;
    CryptoWishList nextKEXcryptoWishList;
    DHGexParameters nextKEXdhgexParameters;
    ServerHostKeyVerifier verifier;
    String hostname;
    int port;
    static /* synthetic */ Class class$ch$ethz$ssh2$transport$KexManager;

    public KexManager(TransportManager transportManager, ClientServerHello clientServerHello, CryptoWishList cryptoWishList, String string, int n, ServerHostKeyVerifier serverHostKeyVerifier) {
        this.tm = transportManager;
        this.csh = clientServerHello;
        this.nextKEXcryptoWishList = cryptoWishList;
        this.nextKEXdhgexParameters = new DHGexParameters();
        this.hostname = string;
        this.port = n;
        this.verifier = serverHostKeyVerifier;
    }

    public ConnectionInfo getOrWaitForConnectionInfo(int n) throws IOException {
        Object object = this.accessLock;
        synchronized (object) {
            while (true) {
                if (this.lastConnInfo != null && this.lastConnInfo.keyExchangeCounter >= n) {
                    return this.lastConnInfo;
                }
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Key exchange was not finished, connection is closed.").initCause(this.tm.getReasonClosedCause());
                }
                try {
                    this.accessLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private String getFirstMatch(String[] stringArray, String[] stringArray2) throws NegotiateException {
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                return stringArray[i];
            }
        }
        throw new NegotiateException();
    }

    private boolean compareFirstOfNameList(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (stringArray.length == 0 && stringArray2.length == 0) {
            return true;
        }
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        return stringArray[0].equals(stringArray2[0]);
    }

    private boolean isGuessOK(KexParameters kexParameters, KexParameters kexParameters2) {
        if (kexParameters == null || kexParameters2 == null) {
            throw new IllegalArgumentException();
        }
        if (!this.compareFirstOfNameList(kexParameters.kex_algorithms, kexParameters2.kex_algorithms)) {
            return false;
        }
        return this.compareFirstOfNameList(kexParameters.server_host_key_algorithms, kexParameters2.server_host_key_algorithms);
    }

    private NegotiatedParameters mergeKexParameters(KexParameters kexParameters, KexParameters kexParameters2) {
        NegotiatedParameters negotiatedParameters = new NegotiatedParameters();
        try {
            negotiatedParameters.kex_algo = this.getFirstMatch(kexParameters.kex_algorithms, kexParameters2.kex_algorithms);
            log.log(20, "kex_algo=" + negotiatedParameters.kex_algo);
            negotiatedParameters.server_host_key_algo = this.getFirstMatch(kexParameters.server_host_key_algorithms, kexParameters2.server_host_key_algorithms);
            log.log(20, "server_host_key_algo=" + negotiatedParameters.server_host_key_algo);
            negotiatedParameters.enc_algo_client_to_server = this.getFirstMatch(kexParameters.encryption_algorithms_client_to_server, kexParameters2.encryption_algorithms_client_to_server);
            negotiatedParameters.enc_algo_server_to_client = this.getFirstMatch(kexParameters.encryption_algorithms_server_to_client, kexParameters2.encryption_algorithms_server_to_client);
            log.log(20, "enc_algo_client_to_server=" + negotiatedParameters.enc_algo_client_to_server);
            log.log(20, "enc_algo_server_to_client=" + negotiatedParameters.enc_algo_server_to_client);
            negotiatedParameters.mac_algo_client_to_server = this.getFirstMatch(kexParameters.mac_algorithms_client_to_server, kexParameters2.mac_algorithms_client_to_server);
            negotiatedParameters.mac_algo_server_to_client = this.getFirstMatch(kexParameters.mac_algorithms_server_to_client, kexParameters2.mac_algorithms_server_to_client);
            log.log(20, "mac_algo_client_to_server=" + negotiatedParameters.mac_algo_client_to_server);
            log.log(20, "mac_algo_server_to_client=" + negotiatedParameters.mac_algo_server_to_client);
            negotiatedParameters.comp_algo_client_to_server = this.getFirstMatch(kexParameters.compression_algorithms_client_to_server, kexParameters2.compression_algorithms_client_to_server);
            negotiatedParameters.comp_algo_server_to_client = this.getFirstMatch(kexParameters.compression_algorithms_server_to_client, kexParameters2.compression_algorithms_server_to_client);
            log.log(20, "comp_algo_client_to_server=" + negotiatedParameters.comp_algo_client_to_server);
            log.log(20, "comp_algo_server_to_client=" + negotiatedParameters.comp_algo_server_to_client);
        }
        catch (NegotiateException negotiateException) {
            return null;
        }
        try {
            negotiatedParameters.lang_client_to_server = this.getFirstMatch(kexParameters.languages_client_to_server, kexParameters2.languages_client_to_server);
        }
        catch (NegotiateException negotiateException) {
            negotiatedParameters.lang_client_to_server = null;
        }
        try {
            negotiatedParameters.lang_server_to_client = this.getFirstMatch(kexParameters.languages_server_to_client, kexParameters2.languages_server_to_client);
        }
        catch (NegotiateException negotiateException) {
            negotiatedParameters.lang_server_to_client = null;
        }
        if (this.isGuessOK(kexParameters, kexParameters2)) {
            negotiatedParameters.guessOK = true;
        }
        return negotiatedParameters;
    }

    public synchronized void initiateKEX(CryptoWishList cryptoWishList, DHGexParameters dHGexParameters) throws IOException {
        this.nextKEXcryptoWishList = cryptoWishList;
        this.nextKEXdhgexParameters = dHGexParameters;
        if (this.kxs == null) {
            PacketKexInit packetKexInit;
            this.kxs = new KexState();
            this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
            this.kxs.localKEX = packetKexInit = new PacketKexInit(this.nextKEXcryptoWishList);
            this.tm.sendKexMessage(packetKexInit.getPayload());
        }
    }

    private boolean establishKeyMaterial() {
        try {
            int n = MAC.getKeyLen(this.kxs.np.mac_algo_client_to_server);
            int n2 = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_client_to_server);
            int n3 = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_client_to_server);
            int n4 = MAC.getKeyLen(this.kxs.np.mac_algo_server_to_client);
            int n5 = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_server_to_client);
            int n6 = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_server_to_client);
            this.km = KeyMaterial.create("SHA1", this.kxs.H, this.kxs.K, this.sessionId, n2, n3, n, n5, n6, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private void finishKex() throws IOException {
        MAC mAC;
        BlockCipher blockCipher;
        if (this.sessionId == null) {
            this.sessionId = this.kxs.H;
        }
        this.establishKeyMaterial();
        PacketNewKeys packetNewKeys = new PacketNewKeys();
        this.tm.sendKexMessage(packetNewKeys.getPayload());
        try {
            blockCipher = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_client_to_server, true, this.km.enc_key_client_to_server, this.km.initial_iv_client_to_server);
            mAC = new MAC(this.kxs.np.mac_algo_client_to_server, this.km.integrity_key_client_to_server);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Fatal error during MAC startup!");
        }
        this.tm.changeSendCipher(blockCipher, mAC);
        this.tm.kexFinished();
    }

    public static final String[] getDefaultServerHostkeyAlgorithmList() {
        return new String[]{"ssh-rsa", "ssh-dss"};
    }

    public static final void checkServerHostkeyAlgorithmsList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("ssh-rsa".equals(stringArray[i]) || "ssh-dss".equals(stringArray[i])) continue;
            throw new IllegalArgumentException("Unknown server host key algorithm '" + stringArray[i] + "'");
        }
    }

    public static final String[] getDefaultKexAlgorithmList() {
        return new String[]{"diffie-hellman-group-exchange-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group1-sha1"};
    }

    public static final void checkKexAlgorithmList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("diffie-hellman-group-exchange-sha1".equals(stringArray[i]) || "diffie-hellman-group14-sha1".equals(stringArray[i]) || "diffie-hellman-group1-sha1".equals(stringArray[i])) continue;
            throw new IllegalArgumentException("Unknown kex algorithm '" + stringArray[i] + "'");
        }
    }

    private boolean verifySignature(byte[] byArray, byte[] byArray2) throws IOException {
        if (this.kxs.np.server_host_key_algo.equals("ssh-rsa")) {
            RSASignature rSASignature = RSASHA1Verify.decodeSSHRSASignature(byArray);
            RSAPublicKey rSAPublicKey = RSASHA1Verify.decodeSSHRSAPublicKey(byArray2);
            log.log(50, "Verifying ssh-rsa signature");
            return RSASHA1Verify.verifySignature(this.kxs.H, rSASignature, rSAPublicKey);
        }
        if (this.kxs.np.server_host_key_algo.equals("ssh-dss")) {
            DSASignature dSASignature = DSASHA1Verify.decodeSSHDSASignature(byArray);
            DSAPublicKey dSAPublicKey = DSASHA1Verify.decodeSSHDSAPublicKey(byArray2);
            log.log(50, "Verifying ssh-dss signature");
            return DSASHA1Verify.verifySignature(this.kxs.H, dSASignature, dSAPublicKey);
        }
        throw new IOException("Unknown server host key algorithm '" + this.kxs.np.server_host_key_algo + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleMessage(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            Object object = this.accessLock;
            synchronized (object) {
                this.connectionClosed = true;
                this.accessLock.notifyAll();
                return;
            }
        }
        if (this.kxs == null && byArray[0] != 20) {
            throw new IOException("Unexpected KEX message (type " + byArray[0] + ")");
        }
        if (this.ignore_next_kex_packet) {
            this.ignore_next_kex_packet = false;
            return;
        }
        if (byArray[0] == 20) {
            PacketKexInit packetKexInit;
            if (this.kxs != null && this.kxs.state != 0) {
                throw new IOException("Unexpected SSH_MSG_KEXINIT message during on-going kex exchange!");
            }
            if (this.kxs == null) {
                this.kxs = new KexState();
                this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
                this.kxs.localKEX = packetKexInit = new PacketKexInit(this.nextKEXcryptoWishList);
                this.tm.sendKexMessage(packetKexInit.getPayload());
            }
            this.kxs.remoteKEX = packetKexInit = new PacketKexInit(byArray, 0, n);
            this.kxs.np = this.mergeKexParameters(this.kxs.localKEX.getKexParameters(), this.kxs.remoteKEX.getKexParameters());
            if (this.kxs.np == null) {
                throw new IOException("Cannot negotiate, proposals do not match.");
            }
            if (this.kxs.remoteKEX.isFirst_kex_packet_follows() && !this.kxs.np.guessOK) {
                this.ignore_next_kex_packet = true;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
                PacketKexDhGexRequest packetKexDhGexRequest = new PacketKexDhGexRequest(this.kxs.dhgexParameters);
                this.tm.sendKexMessage(packetKexDhGexRequest.getPayload());
                this.kxs.state = 1;
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1")) {
                this.kxs.dhx = new DhExchange();
                if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1")) {
                    this.kxs.dhx.init(1);
                } else {
                    this.kxs.dhx.init(14);
                }
                PacketKexDHInit packetKexDHInit = new PacketKexDHInit(this.kxs.dhx.getE());
                this.tm.sendKexMessage(packetKexDHInit.getPayload());
                this.kxs.state = 1;
                return;
            }
            throw new IllegalStateException("Unkown KEX method!");
        }
        if (byArray[0] == 21) {
            MAC mAC;
            BlockCipher blockCipher;
            if (this.km == null) {
                throw new IOException("Peer sent SSH_MSG_NEWKEYS, but I have no key material ready!");
            }
            try {
                blockCipher = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_server_to_client, false, this.km.enc_key_server_to_client, this.km.initial_iv_server_to_client);
                mAC = new MAC(this.kxs.np.mac_algo_server_to_client, this.km.integrity_key_server_to_client);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Fatal error during MAC startup!");
            }
            this.tm.changeRecvCipher(blockCipher, mAC);
            ConnectionInfo connectionInfo = new ConnectionInfo();
            ++this.kexCount;
            connectionInfo.keyExchangeAlgorithm = this.kxs.np.kex_algo;
            connectionInfo.keyExchangeCounter = this.kexCount;
            connectionInfo.clientToServerCryptoAlgorithm = this.kxs.np.enc_algo_client_to_server;
            connectionInfo.serverToClientCryptoAlgorithm = this.kxs.np.enc_algo_server_to_client;
            connectionInfo.clientToServerMACAlgorithm = this.kxs.np.mac_algo_client_to_server;
            connectionInfo.serverToClientMACAlgorithm = this.kxs.np.mac_algo_server_to_client;
            connectionInfo.serverHostKeyAlgorithm = this.kxs.np.server_host_key_algo;
            connectionInfo.serverHostKey = this.kxs.hostkey;
            Object object = this.accessLock;
            synchronized (object) {
                this.lastConnInfo = connectionInfo;
                this.accessLock.notifyAll();
            }
            this.kxs = null;
            return;
        }
        if (this.kxs == null || this.kxs.state == 0) {
            throw new IOException("Unexpected Kex submessage!");
        }
        if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
            if (this.kxs.state == 1) {
                PacketKexDhGexGroup packetKexDhGexGroup = new PacketKexDhGexGroup(byArray, 0, n);
                this.kxs.dhgx = new DhGroupExchange(packetKexDhGexGroup.getP(), packetKexDhGexGroup.getG());
                this.kxs.dhgx.init();
                PacketKexDhGexInit packetKexDhGexInit = new PacketKexDhGexInit(this.kxs.dhgx.getE());
                this.tm.sendKexMessage(packetKexDhGexInit.getPayload());
                this.kxs.state = 2;
                return;
            }
            if (this.kxs.state == 2) {
                PacketKexDhGexReply packetKexDhGexReply = new PacketKexDhGexReply(byArray, 0, n);
                this.kxs.dhgx.setF(packetKexDhGexReply.getF());
                this.kxs.hostkey = packetKexDhGexReply.getHostKey();
                try {
                    this.kxs.H = this.kxs.dhgx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), packetKexDhGexReply.getHostKey(), this.kxs.dhgexParameters);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw (IOException)new IOException("KEX error.").initCause(illegalArgumentException);
                }
                boolean bl = this.verifySignature(packetKexDhGexReply.getSignature(), this.kxs.hostkey);
                if (!bl) {
                    throw new IOException("Hostkey signature sent by remote is wrong!");
                }
                if (this.verifier != null) {
                    boolean bl2 = false;
                    try {
                        bl2 = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey);
                    }
                    catch (Exception exception) {
                        throw (IOException)new IOException("The server hostkey was not accepted by the verifier callback.").initCause(exception);
                    }
                    if (!bl2) {
                        throw new IOException("The server hostkey was not accepted by the verifier callback");
                    }
                }
                this.kxs.K = this.kxs.dhgx.getK();
                this.finishKex();
                return;
            }
            throw new IllegalStateException("Illegal State in KEX Exchange!");
        }
        if ((this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1")) && this.kxs.state == 1) {
            PacketKexDHReply packetKexDHReply = new PacketKexDHReply(byArray, 0, n);
            this.kxs.hostkey = packetKexDHReply.getHostKey();
            this.kxs.dhx.setF(packetKexDHReply.getF());
            try {
                this.kxs.H = this.kxs.dhx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), packetKexDHReply.getHostKey());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException("KEX error.").initCause(illegalArgumentException);
            }
            boolean bl = this.verifySignature(packetKexDHReply.getSignature(), this.kxs.hostkey);
            if (!bl) {
                throw new IOException("Hostkey signature sent by remote is wrong!");
            }
            if (this.verifier != null) {
                boolean bl3 = false;
                try {
                    bl3 = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey);
                }
                catch (Exception exception) {
                    throw (IOException)new IOException("The server hostkey was not accepted by the verifier callback.").initCause(exception);
                }
                if (!bl3) {
                    throw new IOException("The server hostkey was not accepted by the verifier callback");
                }
            }
            this.kxs.K = this.kxs.dhx.getK();
            this.finishKex();
            return;
        }
        throw new IllegalStateException("Unkown KEX method! (" + this.kxs.np.kex_algo + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

