/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketOpenSessionChannel {
    byte[] payload;
    int channelID;
    int initialWindowSize;
    int maxPacketSize;

    public PacketOpenSessionChannel(int n, int n2, int n3) {
        this.channelID = n;
        this.initialWindowSize = n2;
        this.maxPacketSize = n3;
    }

    public PacketOpenSessionChannel(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        if (n3 != 90) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_OPEN! (" + n3 + ")");
        }
        this.channelID = typesReader.readUINT32();
        this.initialWindowSize = typesReader.readUINT32();
        this.maxPacketSize = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_OPEN packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(90);
            typesWriter.writeString("session");
            typesWriter.writeUINT32(this.channelID);
            typesWriter.writeUINT32(this.initialWindowSize);
            typesWriter.writeUINT32(this.maxPacketSize);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

