/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.crypto.digest.SHA1;
import java.math.BigInteger;

public class HashForSSH2Types {
    Digest md;

    public HashForSSH2Types(Digest digest) {
        this.md = digest;
    }

    public HashForSSH2Types(String string) {
        if (string.equals("SHA1")) {
            this.md = new SHA1();
        } else if (string.equals("MD5")) {
            this.md = new MD5();
        } else {
            throw new IllegalArgumentException("Unknown algorithm " + string);
        }
    }

    public void updateByte(byte by) {
        byte[] byArray = new byte[]{by};
        this.md.update(byArray);
    }

    public void updateBytes(byte[] byArray) {
        this.md.update(byArray);
    }

    public void updateUINT32(int n) {
        this.md.update((byte)(n >> 24));
        this.md.update((byte)(n >> 16));
        this.md.update((byte)(n >> 8));
        this.md.update((byte)n);
    }

    public void updateByteString(byte[] byArray) {
        this.updateUINT32(byArray.length);
        this.updateBytes(byArray);
    }

    public void updateBigInt(BigInteger bigInteger) {
        this.updateByteString(bigInteger.toByteArray());
    }

    public void reset() {
        this.md.reset();
    }

    public int getDigestLength() {
        return this.md.getDigestLength();
    }

    public byte[] getDigest() {
        byte[] byArray = new byte[this.md.getDigestLength()];
        this.getDigest(byArray);
        return byArray;
    }

    public void getDigest(byte[] byArray) {
        this.getDigest(byArray, 0);
    }

    public void getDigest(byte[] byArray, int n) {
        this.md.digest(byArray, n);
    }
}

