/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream {
    BlockCipher currentCipher;
    OutputStream bo;
    byte[] buffer;
    byte[] enc;
    int blockSize;
    int pos;
    final int BUFF_SIZE = 2048;
    byte[] out_buffer = new byte[2048];
    int out_buffer_pos = 0;

    public CipherOutputStream(BlockCipher blockCipher, OutputStream outputStream) {
        this.bo = outputStream;
        this.changeCipher(blockCipher);
    }

    private void internal_write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = 2048 - this.out_buffer_pos;
            int n4 = n2 > n3 ? n3 : n2;
            System.arraycopy(byArray, n, this.out_buffer, this.out_buffer_pos, n4);
            n += n4;
            this.out_buffer_pos += n4;
            n2 -= n4;
            if (this.out_buffer_pos < 2048) continue;
            this.bo.write(this.out_buffer, 0, 2048);
            this.out_buffer_pos = 0;
        }
    }

    private void internal_write(int n) throws IOException {
        this.out_buffer[this.out_buffer_pos++] = (byte)n;
        if (this.out_buffer_pos >= 2048) {
            this.bo.write(this.out_buffer, 0, 2048);
            this.out_buffer_pos = 0;
        }
    }

    public void flush() throws IOException {
        if (this.pos != 0) {
            throw new IOException("FATAL: cannot flush since crypto buffer is not aligned.");
        }
        if (this.out_buffer_pos > 0) {
            this.bo.write(this.out_buffer, 0, this.out_buffer_pos);
            this.out_buffer_pos = 0;
        }
        this.bo.flush();
    }

    public void changeCipher(BlockCipher blockCipher) {
        this.currentCipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = 0;
    }

    private void writeBlock() throws IOException {
        try {
            this.currentCipher.transformBlock(this.buffer, 0, this.enc, 0);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Error while decrypting block.").initCause(exception);
        }
        this.internal_write(this.enc, 0, this.blockSize);
        this.pos = 0;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.blockSize - this.pos;
            int n4 = Math.min(n3, n2);
            System.arraycopy(byArray, n, this.buffer, this.pos, n4);
            this.pos += n4;
            n += n4;
            n2 -= n4;
            if (this.pos < this.blockSize) continue;
            this.writeBlock();
        }
    }

    public void write(int n) throws IOException {
        this.buffer[this.pos++] = (byte)n;
        if (this.pos >= this.blockSize) {
            this.writeBlock();
        }
    }

    public void writePlain(int n) throws IOException {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.internal_write(n);
    }

    public void writePlain(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.internal_write(byArray, n, n2);
    }
}

