/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import ch.ethz.ssh2.crypto.cipher.CTRMode;
import java.util.Vector;

public class BlockCipherFactory {
    static Vector ciphers = new Vector();

    public static String[] getDefaultCipherList() {
        String[] stringArray = new String[ciphers.size()];
        for (int i = 0; i < ciphers.size(); ++i) {
            CipherEntry cipherEntry = (CipherEntry)ciphers.elementAt(i);
            stringArray[i] = new String(cipherEntry.type);
        }
        return stringArray;
    }

    public static void checkCipherList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            BlockCipherFactory.getEntry(stringArray[i]);
        }
    }

    public static BlockCipher createCipher(String string, boolean bl, byte[] byArray, byte[] byArray2) {
        try {
            CipherEntry cipherEntry = BlockCipherFactory.getEntry(string);
            Class<?> clazz = Class.forName(cipherEntry.cipherClass);
            BlockCipher blockCipher = (BlockCipher)clazz.newInstance();
            if (string.endsWith("-cbc")) {
                blockCipher.init(bl, byArray);
                return new CBCMode(blockCipher, byArray2, bl);
            }
            if (string.endsWith("-ctr")) {
                blockCipher.init(true, byArray);
                return new CTRMode(blockCipher, byArray2, bl);
            }
            throw new IllegalArgumentException("Cannot instantiate " + string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot instantiate " + string);
        }
    }

    private static CipherEntry getEntry(String string) {
        for (int i = 0; i < ciphers.size(); ++i) {
            CipherEntry cipherEntry = (CipherEntry)ciphers.elementAt(i);
            if (!cipherEntry.type.equals(string)) continue;
            return cipherEntry;
        }
        throw new IllegalArgumentException("Unkown algorithm " + string);
    }

    public static int getBlockSize(String string) {
        CipherEntry cipherEntry = BlockCipherFactory.getEntry(string);
        return cipherEntry.blocksize;
    }

    public static int getKeySize(String string) {
        CipherEntry cipherEntry = BlockCipherFactory.getEntry(string);
        return cipherEntry.keysize;
    }

    static {
        ciphers.addElement(new CipherEntry("aes256-ctr", 16, 32, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes192-ctr", 16, 24, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes128-ctr", 16, 16, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("blowfish-ctr", 8, 16, "ch.ethz.ssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new CipherEntry("aes256-cbc", 16, 32, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes192-cbc", 16, 24, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes128-cbc", 16, 16, "ch.ethz.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("blowfish-cbc", 8, 16, "ch.ethz.ssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new CipherEntry("3des-ctr", 8, 24, "ch.ethz.ssh2.crypto.cipher.DESede"));
        ciphers.addElement(new CipherEntry("3des-cbc", 8, 24, "ch.ethz.ssh2.crypto.cipher.DESede"));
    }

    static class CipherEntry {
        String type;
        int blocksize;
        int keysize;
        String cipherClass;

        public CipherEntry(String string, int n, int n2, String string2) {
            this.type = string;
            this.blocksize = n;
            this.keysize = n2;
            this.cipherClass = string2;
        }
    }
}

