/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelInputStream;
import ch.ethz.ssh2.channel.ChannelOutputStream;
import ch.ethz.ssh2.channel.StreamForwarder;
import ch.ethz.ssh2.channel.X11ServerData;
import ch.ethz.ssh2.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RemoteX11AcceptThread
extends Thread {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$channel$RemoteX11AcceptThread == null ? (class$ch$ethz$ssh2$channel$RemoteX11AcceptThread = RemoteX11AcceptThread.class$("ch.ethz.ssh2.channel.RemoteX11AcceptThread")) : class$ch$ethz$ssh2$channel$RemoteX11AcceptThread);
    Channel c;
    String remoteOriginatorAddress;
    int remoteOriginatorPort;
    Socket s;
    static /* synthetic */ Class class$ch$ethz$ssh2$channel$RemoteX11AcceptThread;

    public RemoteX11AcceptThread(Channel channel, String string, int n) {
        this.c = channel;
        this.remoteOriginatorAddress = string;
        this.remoteOriginatorPort = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object;
            Object object2;
            this.c.cm.sendOpenConfirmation(this.c);
            ChannelOutputStream channelOutputStream = this.c.getStdinStream();
            ChannelInputStream channelInputStream = this.c.getStdoutStream();
            byte[] byArray = new byte[6];
            if (((InputStream)channelInputStream).read(byArray) != 6) {
                throw new IOException("Unexpected EOF on startup!");
            }
            if (byArray[0] != 66 && byArray[0] != 108) {
                throw new IOException("Unknown endian format in X11 message!");
            }
            int n = byArray[0] == 66 ? 0 : 1;
            byte[] byArray2 = new byte[6];
            if (((InputStream)channelInputStream).read(byArray2) != 6) {
                throw new IOException("Unexpected EOF on startup!");
            }
            int n2 = (byArray2[n] & 0xFF) << 8 | byArray2[1 - n] & 0xFF;
            int n3 = (byArray2[2 + n] & 0xFF) << 8 | byArray2[3 - n] & 0xFF;
            if (n2 > 256 || n3 > 256) {
                throw new IOException("Buggy authorization data");
            }
            int n4 = (4 - n2 % 4) % 4;
            int n5 = (4 - n3 % 4) % 4;
            byte[] byArray3 = new byte[n2];
            byte[] byArray4 = new byte[n3];
            byte[] byArray5 = new byte[4];
            if (((InputStream)channelInputStream).read(byArray3) != n2) {
                throw new IOException("Unexpected EOF on startup! (authProtocolName)");
            }
            if (((InputStream)channelInputStream).read(byArray5, 0, n4) != n4) {
                throw new IOException("Unexpected EOF on startup! (authProtocolNamePadding)");
            }
            if (((InputStream)channelInputStream).read(byArray4) != n3) {
                throw new IOException("Unexpected EOF on startup! (authProtocolData)");
            }
            if (((InputStream)channelInputStream).read(byArray5, 0, n5) != n5) {
                throw new IOException("Unexpected EOF on startup! (authProtocolDataPadding)");
            }
            if (!"MIT-MAGIC-COOKIE-1".equals(new String(byArray3))) {
                throw new IOException("Unknown authorization protocol!");
            }
            if (n3 != 16) {
                throw new IOException("Wrong data length for authorization data!");
            }
            StringBuffer stringBuffer = new StringBuffer(32);
            for (int i = 0; i < byArray4.length; ++i) {
                object2 = Integer.toHexString(byArray4[i] & 0xFF);
                stringBuffer.append((String)(((String)object2).length() == 2 ? object2 : "0" + (String)object2));
            }
            String string = stringBuffer.toString();
            object2 = this.c;
            synchronized (object2) {
                this.c.hexX11FakeCookie = string;
            }
            object2 = this.c.cm.checkX11Cookie(string);
            if (object2 == null) {
                throw new IOException("Invalid X11 cookie received.");
            }
            this.s = new Socket(((X11ServerData)object2).hostname, ((X11ServerData)object2).port);
            OutputStream outputStream = this.s.getOutputStream();
            InputStream inputStream = this.s.getInputStream();
            outputStream.write(byArray);
            if (((X11ServerData)object2).x11_magic_cookie == null) {
                object = new byte[6];
                outputStream.write((byte[])object);
            } else {
                if (((X11ServerData)object2).x11_magic_cookie.length != 16) {
                    throw new IOException("The real X11 cookie has an invalid length!");
                }
                outputStream.write(byArray2);
                outputStream.write(byArray3);
                outputStream.write(byArray5, 0, n4);
                outputStream.write(((X11ServerData)object2).x11_magic_cookie);
                outputStream.write(byArray5, 0, n5);
            }
            outputStream.flush();
            object = new StreamForwarder(this.c, null, null, channelInputStream, outputStream, "RemoteToX11");
            StreamForwarder streamForwarder = new StreamForwarder(this.c, null, null, inputStream, channelOutputStream, "X11ToRemote");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            streamForwarder.run();
            while (((Thread)object).isAlive()) {
                try {
                    ((Thread)object).join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.c.cm.closeChannel(this.c, "EOF on both X11 streams reached.");
            this.s.close();
        }
        catch (IOException iOException) {
            log.log(50, "IOException in X11 proxy code: " + iOException.getMessage());
            try {
                this.c.cm.closeChannel(this.c, "IOException in X11 proxy code (" + iOException.getMessage() + ")");
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

