/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.auth;

import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.packets.PacketServiceAccept;
import ch.ethz.ssh2.packets.PacketServiceRequest;
import ch.ethz.ssh2.packets.PacketUserauthBanner;
import ch.ethz.ssh2.packets.PacketUserauthFailure;
import ch.ethz.ssh2.packets.PacketUserauthInfoRequest;
import ch.ethz.ssh2.packets.PacketUserauthInfoResponse;
import ch.ethz.ssh2.packets.PacketUserauthRequestInteractive;
import ch.ethz.ssh2.packets.PacketUserauthRequestNone;
import ch.ethz.ssh2.packets.PacketUserauthRequestPassword;
import ch.ethz.ssh2.packets.PacketUserauthRequestPublicKey;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.util.Vector;

public class AuthenticationManager
implements MessageHandler {
    TransportManager tm;
    Vector packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = null;
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager transportManager) {
        this.tm = transportManager;
    }

    boolean methodPossible(String string) {
        if (this.remainingMethods == null) {
            return false;
        }
        for (int i = 0; i < this.remainingMethods.length; ++i) {
            if (this.remainingMethods[i].compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            while (this.packets.size() == 0) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("The connection is closed.").initCause(this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            byte[] byArray = (byte[])this.packets.firstElement();
            this.packets.removeElementAt(0);
            return byArray;
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] byArray;
        while ((byArray = this.deQueue())[0] == 53) {
            PacketUserauthBanner packetUserauthBanner = new PacketUserauthBanner(byArray, 0, byArray.length);
            this.banner = packetUserauthBanner.getBanner();
        }
        return byArray;
    }

    public String[] getRemainingMethods(String string) throws IOException {
        this.initialize(string);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String string) throws IOException {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest packetServiceRequest = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(packetServiceRequest.getPayload());
            PacketUserauthRequestNone packetUserauthRequestNone = new PacketUserauthRequestNone("ssh-connection", string);
            this.tm.sendMessage(packetUserauthRequestNone.getPayload());
            byte[] byArray = this.getNextMessage();
            new PacketServiceAccept(byArray, 0, byArray.length);
            byArray = this.getNextMessage();
            this.initDone = true;
            if (byArray[0] == 52) {
                this.authenticated = true;
                return true;
            }
            if (byArray[0] == 51) {
                PacketUserauthFailure packetUserauthFailure = new PacketUserauthFailure(byArray, 0, byArray.length);
                this.remainingMethods = packetUserauthFailure.getAuthThatCanContinue();
                this.isPartialSuccess = packetUserauthFailure.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticatePublicKey(String string, char[] cArray, String string2) throws IOException {
        try {
            Object object;
            Object object2;
            this.initialize(string);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            Object object3 = PEMDecoder.decode(cArray, string2);
            if (object3 instanceof DSAPrivateKey) {
                object2 = (DSAPrivateKey)object3;
                object = DSASHA1Verify.encodeSSHDSAPublicKey(((DSAPrivateKey)object2).getPublicKey());
                TypesWriter typesWriter = new TypesWriter();
                byte[] byArray = this.tm.getSessionIdentifier();
                typesWriter.writeString(byArray, 0, byArray.length);
                typesWriter.writeByte(50);
                typesWriter.writeString(string);
                typesWriter.writeString("ssh-connection");
                typesWriter.writeString("publickey");
                typesWriter.writeBoolean(true);
                typesWriter.writeString("ssh-dss");
                typesWriter.writeString((byte[])object, 0, ((byte[])object).length);
                byte[] byArray2 = typesWriter.getBytes();
                DSASignature dSASignature = DSASHA1Verify.generateSignature(byArray2, (DSAPrivateKey)object2);
                byte[] byArray3 = DSASHA1Verify.encodeSSHDSASignature(dSASignature);
                PacketUserauthRequestPublicKey packetUserauthRequestPublicKey = new PacketUserauthRequestPublicKey("ssh-connection", string, "ssh-dss", (byte[])object, byArray3);
                this.tm.sendMessage(packetUserauthRequestPublicKey.getPayload());
            } else if (object3 instanceof RSAPrivateKey) {
                object2 = (RSAPrivateKey)object3;
                object = RSASHA1Verify.encodeSSHRSAPublicKey(((RSAPrivateKey)object2).getPublicKey());
                TypesWriter typesWriter = new TypesWriter();
                byte[] byArray = this.tm.getSessionIdentifier();
                typesWriter.writeString(byArray, 0, byArray.length);
                typesWriter.writeByte(50);
                typesWriter.writeString(string);
                typesWriter.writeString("ssh-connection");
                typesWriter.writeString("publickey");
                typesWriter.writeBoolean(true);
                typesWriter.writeString("ssh-rsa");
                typesWriter.writeString((byte[])object, 0, ((byte[])object).length);
                byArray = typesWriter.getBytes();
                RSASignature rSASignature = RSASHA1Verify.generateSignature(byArray, (RSAPrivateKey)object2);
                byte[] byArray4 = RSASHA1Verify.encodeSSHRSASignature(rSASignature);
                PacketUserauthRequestPublicKey packetUserauthRequestPublicKey = new PacketUserauthRequestPublicKey("ssh-connection", string, "ssh-rsa", (byte[])object, byArray4);
                this.tm.sendMessage(packetUserauthRequestPublicKey.getPayload());
            } else {
                throw new IOException("Unknown private key type returned from PEM decoder.");
            }
            object2 = this.getNextMessage();
            if (object2[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (object2[0] == 51) {
                object = new PacketUserauthFailure((byte[])object2, 0, ((Object)object2).length);
                this.remainingMethods = ((PacketUserauthFailure)object).getAuthThatCanContinue();
                this.isPartialSuccess = ((PacketUserauthFailure)object).isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + (int)object2[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Publickey authentication failed.").initCause(iOException);
        }
    }

    public boolean authenticatePassword(String string, String string2) throws IOException {
        try {
            this.initialize(string);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword packetUserauthRequestPassword = new PacketUserauthRequestPassword("ssh-connection", string, string2);
            this.tm.sendMessage(packetUserauthRequestPassword.getPayload());
            byte[] byArray = this.getNextMessage();
            if (byArray[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (byArray[0] == 51) {
                PacketUserauthFailure packetUserauthFailure = new PacketUserauthFailure(byArray, 0, byArray.length);
                this.remainingMethods = packetUserauthFailure.getAuthThatCanContinue();
                this.isPartialSuccess = packetUserauthFailure.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Password authentication failed.").initCause(iOException);
        }
    }

    public boolean authenticateInteractive(String string, String[] stringArray, InteractiveCallback interactiveCallback) throws IOException {
        try {
            byte[] byArray;
            this.initialize(string);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            PacketUserauthRequestInteractive packetUserauthRequestInteractive = new PacketUserauthRequestInteractive("ssh-connection", string, stringArray);
            this.tm.sendMessage(packetUserauthRequestInteractive.getPayload());
            while (true) {
                String[] stringArray2;
                Object object;
                if ((byArray = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (byArray[0] == 51) {
                    object = new PacketUserauthFailure(byArray, 0, byArray.length);
                    this.remainingMethods = ((PacketUserauthFailure)object).getAuthThatCanContinue();
                    this.isPartialSuccess = ((PacketUserauthFailure)object).isPartialSuccess();
                    return false;
                }
                if (byArray[0] != 60) break;
                object = new PacketUserauthInfoRequest(byArray, 0, byArray.length);
                try {
                    stringArray2 = interactiveCallback.replyToChallenge(((PacketUserauthInfoRequest)object).getName(), ((PacketUserauthInfoRequest)object).getInstruction(), ((PacketUserauthInfoRequest)object).getNumPrompts(), ((PacketUserauthInfoRequest)object).getPrompt(), ((PacketUserauthInfoRequest)object).getEcho());
                }
                catch (Exception exception) {
                    throw (IOException)new IOException("Exception in callback.").initCause(exception);
                }
                if (stringArray2 == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse packetUserauthInfoResponse = new PacketUserauthInfoResponse(stringArray2);
                this.tm.sendMessage(packetUserauthInfoResponse.getPayload());
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Keyboard-interactive authentication failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] byArray, int n) throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            if (byArray == null) {
                this.connectionClosed = true;
            } else {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                this.packets.addElement(byArray2);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }
}

