/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.channel.X11ServerData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class Session {
    ChannelManager cm;
    Channel cn;
    boolean flag_pty_requested = false;
    boolean flag_x11_requested = false;
    boolean flag_execution_started = false;
    boolean flag_closed = false;
    String x11FakeCookie = null;

    Session(ChannelManager channelManager) throws IOException {
        this.cm = channelManager;
        this.cn = channelManager.openSessionChannel();
    }

    public synchronized void requestDumbPTY() throws IOException {
        this.requestPTY("dumb", 0, 0, 0, 0, null);
    }

    public synchronized void requestPTY(String string) throws IOException {
        this.requestPTY(string, 0, 0, 0, 0, null);
    }

    public synchronized void requestPTY(String string, int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_pty_requested) {
            throw new IOException("A PTY was already requested.");
        }
        if (this.flag_execution_started) {
            throw new IOException("Cannot request PTY at this stage anymore, a remote execution has already started.");
        }
        if (string == null) {
            throw new IllegalArgumentException("TERM cannot be null.");
        }
        if (byArray != null && byArray.length > 0) {
            if (byArray[byArray.length - 1] != 0) {
                throw new IOException("Illegal terminal modes description, does not end in zero byte");
            }
        } else {
            byArray = new byte[]{0};
        }
        this.flag_pty_requested = true;
        this.cm.requestPTY(this.cn, string, n, n2, n3, n4, byArray);
    }

    public synchronized void requestX11Forwarding(String string, int n, byte[] byArray, boolean bl) throws IOException {
        StringBuffer stringBuffer;
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("hostname argument may not be null");
        }
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_x11_requested) {
            throw new IOException("X11 forwarding was already requested.");
        }
        if (this.flag_execution_started) {
            throw new IOException("Cannot request X11 forwarding at this stage anymore, a remote execution has already started.");
        }
        this.flag_x11_requested = true;
        X11ServerData x11ServerData = new X11ServerData();
        x11ServerData.hostname = string;
        x11ServerData.port = n;
        x11ServerData.x11_magic_cookie = byArray;
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[16];
        do {
            secureRandom.nextBytes(byArray2);
            stringBuffer = new StringBuffer(32);
            for (int i = 0; i < byArray2.length; ++i) {
                String string3 = Integer.toHexString(byArray2[i] & 0xFF);
                stringBuffer.append(string3.length() == 2 ? string3 : "0" + string3);
            }
        } while (this.cm.checkX11Cookie(string2 = stringBuffer.toString()) != null);
        this.cm.requestX11(this.cn, bl, "MIT-MAGIC-COOKIE-1", string2, 0);
        this.x11FakeCookie = string2;
        this.cm.registerX11Cookie(string2, x11ServerData);
    }

    public synchronized void execCommand(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("cmd argument may not be null");
        }
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_execution_started) {
            throw new IOException("A remote execution has already started.");
        }
        this.flag_execution_started = true;
        this.cm.requestExecCommand(this.cn, string);
    }

    public synchronized void startShell() throws IOException {
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_execution_started) {
            throw new IOException("A remote execution has already started.");
        }
        this.flag_execution_started = true;
        this.cm.requestShell(this.cn);
    }

    public synchronized void startSubSystem(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("name argument may not be null");
        }
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_execution_started) {
            throw new IOException("A remote execution has already started.");
        }
        this.flag_execution_started = true;
        this.cm.requestSubSystem(this.cn, string);
    }

    public synchronized InputStream getStdout() {
        return this.cn.getStdoutStream();
    }

    public synchronized InputStream getStderr() {
        return this.cn.getStderrStream();
    }

    public synchronized OutputStream getStdin() {
        return this.cn.getStdinStream();
    }

    public synchronized int waitUntilDataAvailable(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must not be negative!");
        }
        int n = this.cm.waitForCondition(this.cn, l, 28);
        if ((n & 1) != 0) {
            return -1;
        }
        if ((n & 0xC) != 0) {
            return 1;
        }
        if ((n & 0x10) != 0) {
            return 0;
        }
        throw new IllegalStateException("Unexpected condition result (" + n + ")");
    }

    public synchronized int waitForCondition(int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative!");
        }
        return this.cm.waitForCondition(this.cn, l, n);
    }

    public synchronized Integer getExitStatus() {
        return this.cn.getExitStatus();
    }

    public synchronized String getExitSignal() {
        return this.cn.getExitSignal();
    }

    public synchronized void close() {
        if (!this.flag_closed) {
            if (this.x11FakeCookie != null) {
                this.cm.unRegisterX11Cookie(this.x11FakeCookie, true);
            }
            try {
                this.cm.closeChannel(this.cn, "Closed due to user request");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.flag_closed = true;
        }
    }
}

