/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.LocalStreamForwarder;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.auth.AuthenticationManager;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Connection {
    public static final String identification = "Ganymed Build_209_beta3";
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private String hostname;
    private int port;
    private TransportManager tm;
    private boolean tcpNoDelay = false;

    public static synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getDefaultCipherList();
    }

    public static synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public static synchronized String[] getAvailableServerHostKeyAlgorithms() {
        return KexManager.getDefaultServerHostkeyAlgorithmList();
    }

    public Connection(String string) {
        this(string, 22);
    }

    public Connection(String string, int n) {
        this.hostname = string;
        this.port = n;
    }

    public synchronized boolean authenticateWithDSA(String string, String string2, String string3) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("pem argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, string2.toCharArray(), string3);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, InteractiveCallback interactiveCallback) throws IOException {
        return this.authenticateWithKeyboardInteractive(string, null, interactiveCallback);
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, String[] stringArray, InteractiveCallback interactiveCallback) throws IOException {
        if (interactiveCallback == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateInteractive(string, stringArray, interactiveCallback);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String string, String string2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password argument is null");
        }
        this.authenticated = this.am.authenticatePassword(string, string2);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, char[] cArray, String string2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (cArray == null) {
            throw new IllegalArgumentException("pemPrivateKey argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, cArray, string2);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, File file, String string2) throws IOException {
        int n;
        if (file == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] cArray = new char[256];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        FileReader fileReader = new FileReader(file);
        while ((n = fileReader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        fileReader.close();
        return this.authenticateWithPublicKey(string, charArrayWriter.toCharArray(), string2);
    }

    public synchronized void close() {
        if (this.cm != null) {
            this.cm.closeAllChannels();
        }
        if (this.tm != null) {
            Throwable throwable = new Throwable("Closed due to user request.");
            this.tm.close(throwable, true);
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() throws IOException {
        return this.connect(null);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier) throws IOException {
        if (this.tm != null) {
            throw new IOException("Connection to " + this.hostname + " is already in connected state!");
        }
        try {
            this.tm = new TransportManager(this.hostname, this.port);
            this.tm.setTcpNoDelay(this.tcpNoDelay);
            this.tm.initialize(this.cryptoWishList, serverHostKeyVerifier, this.dhgexpara);
            return this.tm.getConnectionInfo(1);
        }
        catch (IOException iOException) {
            this.close();
            throw (IOException)new IOException("The connection to " + this.hostname + " could not be fully established.").initCause(iOException);
        }
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int n, String string, int n2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, n, string, n2);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String string, int n) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, string, n);
    }

    public synchronized SCPClient createSCPClient() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot create SCP client, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot create SCP client, connection is not authenticated.");
        }
        return new SCPClient(this);
    }

    public synchronized void forceKeyExchange() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized String[] getRemainingAuthMethods(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("user argument may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(string);
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthMethodAvailable(String string, String string2) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("method argument may not be NULL!");
        }
        String[] stringArray = this.getRemainingAuthMethods(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public synchronized Session openSession() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm);
    }

    private String[] removeDuplicates(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String string = stringArray[i];
            for (int j = 0; j < n; ++j) {
                if ((string != null || stringArray2[j] != null) && (string == null || !string.equals(stringArray2[j]))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringArray2[n++] = stringArray[i];
        }
        if (n == stringArray2.length) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    public synchronized void setClient2ServerCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.c2s_enc_algos = stringArray;
    }

    public synchronized void setClient2ServerMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.c2s_mac_algos = stringArray;
    }

    public synchronized void setDHGexParameters(DHGexParameters dHGexParameters) {
        if (dHGexParameters == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dHGexParameters;
    }

    public synchronized void setServer2ClientCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.s2c_enc_algos = stringArray;
    }

    public synchronized void setServer2ClientMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.s2c_mac_algos = stringArray;
    }

    public synchronized void setServerHostKeyAlgorithms(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        KexManager.checkServerHostkeyAlgorithmsList(stringArray);
        this.cryptoWishList.serverHostKeyAlgorithms = stringArray;
    }

    public synchronized void setTCPNoDelay(boolean bl) throws IOException {
        this.tcpNoDelay = bl;
        if (this.tm != null) {
            this.tm.setTcpNoDelay(bl);
        }
    }

    public synchronized void requestRemotePortForwarding(String string, int n, String string2, int n2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        if (string == null || string2 == null || n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.cm.requestGlobalForward(string, n, string2, n2);
    }

    public synchronized void cancelRemotePortForwarding(int n) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        this.cm.requestCancelGlobalForward(n);
    }
}

