/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectJAfterAdvice;
import org.springframework.aop.aspectj.AspectJAfterReturningAdvice;
import org.springframework.aop.aspectj.AspectJAfterThrowingAdvice;
import org.springframework.aop.aspectj.AspectJAroundAdvice;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJMethodBeforeAdvice;
import org.springframework.aop.aspectj.DeclareParentsAdvisor;
import org.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.InstantiationModelAwarePointcutAdvisorImpl;
import org.springframework.aop.aspectj.annotation.LazySingletonMetadataAwareAspectInstanceFactoryDecorator;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAspectJAdvisorFactory
extends AbstractAspectJAdvisorFactory {
    @Override
    public List<Advisor> getAdvisors(MetadataAwareAspectInstanceFactory maaif) {
        Class<?> aspectClass = maaif.getAspectMetadata().getAspectClass();
        final String aspectName = maaif.getAspectMetadata().getAspectName();
        this.validate(aspectClass);
        final LazySingletonMetadataAwareAspectInstanceFactoryDecorator lazySingletonAspectInstanceFactory = new LazySingletonMetadataAwareAspectInstanceFactoryDecorator(maaif);
        final LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        ReflectionUtils.doWithMethods(aspectClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method m) throws IllegalArgumentException {
                InstantiationModelAwarePointcutAdvisorImpl pa;
                if (AnnotationUtils.getAnnotation((Method)m, Pointcut.class) == null && (pa = ReflectiveAspectJAdvisorFactory.this.getAdvisor(m, lazySingletonAspectInstanceFactory, advisors.size(), aspectName)) != null) {
                    advisors.add(pa);
                }
            }
        });
        if (!advisors.isEmpty() && lazySingletonAspectInstanceFactory.getAspectMetadata().isLazilyInstantiated()) {
            SyntheticInstantiationAdvisor instantiationAdvisor = new SyntheticInstantiationAdvisor(lazySingletonAspectInstanceFactory);
            advisors.add(0, instantiationAdvisor);
        }
        for (Field f : aspectClass.getDeclaredFields()) {
            Advisor a = this.getDeclareParentsAdvisor(f);
            if (a == null) continue;
            advisors.add(a);
        }
        return advisors;
    }

    private Advisor getDeclareParentsAdvisor(Field introductionField) {
        DeclareParents declareParents = introductionField.getAnnotation(DeclareParents.class);
        if (declareParents == null) {
            return null;
        }
        if (declareParents.defaultImpl() == DeclareParents.class) {
            throw new IllegalStateException("defaultImpl must be set on DeclareParents");
        }
        return new DeclareParentsAdvisor(introductionField.getType(), declareParents.value(), declareParents.defaultImpl());
    }

    @Override
    public InstantiationModelAwarePointcutAdvisorImpl getAdvisor(Method candidateAspectJAdviceMethod, MetadataAwareAspectInstanceFactory aif, int declarationOrderInAspect, String aspectName) {
        this.validate(aif.getAspectMetadata().getAspectClass());
        AspectJExpressionPointcut ajexp = this.getPointcut(candidateAspectJAdviceMethod, aif.getAspectMetadata().getAspectClass());
        if (ajexp == null) {
            return null;
        }
        return new InstantiationModelAwarePointcutAdvisorImpl(this, ajexp, aif, candidateAspectJAdviceMethod, declarationOrderInAspect, aspectName);
    }

    @Override
    public Advice getAdvice(Method candidateAspectJAdviceMethod, AspectJExpressionPointcut ajexp, MetadataAwareAspectInstanceFactory aif, int declarationOrderInAspect, String aspectName) {
        AbstractAspectJAdvice springAdvice;
        Class<?> candidateAspectClass = aif.getAspectMetadata().getAspectClass();
        this.validate(candidateAspectClass);
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAspectJAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        if (!this.isAspect(candidateAspectClass)) {
            throw new AopConfigException("Advice must be declared inside an aspect type: Offending method '" + candidateAspectJAdviceMethod + "' in class " + candidateAspectClass.getName());
        }
        this.logger.debug((Object)("Found AspectJ method " + candidateAspectJAdviceMethod));
        switch (aspectJAnnotation.getAnnotationType()) {
            case AtBefore: {
                springAdvice = new AspectJMethodBeforeAdvice(candidateAspectJAdviceMethod, ajexp, aif);
                break;
            }
            case AtAfter: {
                springAdvice = new AspectJAfterAdvice(candidateAspectJAdviceMethod, ajexp, aif);
                break;
            }
            case AtAfterReturning: {
                springAdvice = new AspectJAfterReturningAdvice(candidateAspectJAdviceMethod, ajexp, aif);
                AfterReturning afterReturningAnnotation = (AfterReturning)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText((String)afterReturningAnnotation.returning())) break;
                springAdvice.setReturningName(afterReturningAnnotation.returning());
                break;
            }
            case AtAfterThrowing: {
                springAdvice = new AspectJAfterThrowingAdvice(candidateAspectJAdviceMethod, ajexp, aif);
                AfterThrowing afterThrowingAnnotation = (AfterThrowing)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText((String)afterThrowingAnnotation.throwing())) break;
                springAdvice.setThrowingName(afterThrowingAnnotation.throwing());
                break;
            }
            case AtAround: {
                springAdvice = new AspectJAroundAdvice(candidateAspectJAdviceMethod, ajexp, aif, this.parameterNameDiscoverer);
                break;
            }
            case AtPointcut: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing pointcut '" + candidateAspectJAdviceMethod.getName() + "'"));
                }
                return null;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported advice type on method " + candidateAspectJAdviceMethod);
            }
        }
        springAdvice.setAspectName(aspectName);
        springAdvice.setDeclarationOrder(declarationOrderInAspect);
        String[] argNames = this.getArgumentNames(candidateAspectJAdviceMethod);
        if (argNames != null) {
            springAdvice.setArgumentNamesFromStringArray(argNames);
        }
        try {
            springAdvice.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Advice configuration failed", ex);
        }
        return (Advice)springAdvice;
    }

    private String[] getArgumentNames(Method forMethod) {
        Class<?> firstArgType;
        String[] argNames = this.parameterNameDiscoverer.getParameterNames(forMethod);
        if (argNames != null && forMethod.getParameterTypes().length == argNames.length + 1 && ((firstArgType = forMethod.getParameterTypes()[0]) == JoinPoint.class || firstArgType == ProceedingJoinPoint.class || firstArgType == JoinPoint.StaticPart.class)) {
            String[] oldNames = argNames;
            argNames = new String[oldNames.length + 1];
            argNames[0] = "THIS_JOIN_POINT";
            System.arraycopy(oldNames, 0, argNames, 1, oldNames.length);
        }
        return argNames;
    }

    private AspectJExpressionPointcut getPointcut(Method candidateAspectJAdviceMethod, Class<?> candidateAspectClass) {
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAspectJAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(candidateAspectClass, new String[0], new Class[0]);
        ajexp.setExpression(aspectJAnnotation.getPointcutExpression());
        return ajexp;
    }

    protected static class SyntheticInstantiationAdvisor
    extends DefaultPointcutAdvisor {
        private static final long serialVersionUID = -7789221134469113954L;

        public SyntheticInstantiationAdvisor(final MetadataAwareAspectInstanceFactory aif) {
            super(aif.getAspectMetadata().getPerClausePointcut(), new MethodBeforeAdvice(){

                public void before(Method method, Object[] args, Object target) {
                    aif.getAspectInstance();
                }
            });
        }
    }
}

