/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.services;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.DefaultSystemPaths;
import com.zutubi.pulse.services.InvalidTokenException;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.test.PulseTestCase;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.io.IOException;

public class ServiceTokenManagerTest
extends PulseTestCase {
    private static final String TEST_TOKEN = "test token string";
    private File tempDir;
    private ServiceTokenManager tokenManager;
    private ConfigurationManager configManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempDir = FileSystemUtils.createTempDir((String)ServiceTokenManager.class.getName(), (String)"");
        this.tokenManager = new ServiceTokenManager();
        DefaultSystemPaths paths = new DefaultSystemPaths(this.tempDir, this.tempDir);
        paths.getConfigRoot().mkdirs();
        Mock mockConfigurationManager = new Mock(ConfigurationManager.class);
        mockConfigurationManager.matchAndReturn("getSystemPaths", C.ANY_ARGS, (Object)paths);
        this.configManager = (ConfigurationManager)mockConfigurationManager.proxy();
        this.tokenManager.setConfigurationManager(this.configManager);
    }

    protected void tearDown() throws Exception {
        this.removeDirectory(this.tempDir);
        super.tearDown();
    }

    public void testGeneratesToken() {
        ServiceTokenManagerTest.assertNull((Object)this.tokenManager.getToken());
        this.tokenManager.init();
        ServiceTokenManagerTest.assertNotNull((Object)this.tokenManager.getToken());
    }

    public void testUsesExistingToken() throws IOException {
        ServiceTokenManagerTest.assertNull((Object)this.tokenManager.getToken());
        File tokenFile = this.tokenManager.getTokenFile();
        FileSystemUtils.createFile((File)tokenFile, (String)TEST_TOKEN);
        this.tokenManager.init();
        ServiceTokenManagerTest.assertEquals((String)TEST_TOKEN, (String)this.tokenManager.getToken());
    }

    public void testAcceptsToken() {
        this.tokenManager.init();
        String token = this.tokenManager.getToken();
        this.tokenManager.validateToken(token);
    }

    public void testRejectsInvalidToken() {
        this.tokenManager.init();
        String token = this.tokenManager.getToken();
        try {
            this.tokenManager.validateToken(token + "invalid");
            ServiceTokenManagerTest.fail();
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
    }

    public void testAcceptsFirstToken() {
        this.tokenManager.setGenerate(false);
        this.tokenManager.init();
        ServiceTokenManagerTest.assertNull((Object)this.tokenManager.getToken());
        this.tokenManager.validateToken(TEST_TOKEN);
        ServiceTokenManagerTest.assertEquals((String)TEST_TOKEN, (String)this.tokenManager.getToken());
    }

    public void testGeneratedTokenPersists() {
        this.tokenManager.init();
        String token = this.tokenManager.getToken();
        ServiceTokenManager another = new ServiceTokenManager();
        another.setConfigurationManager(this.configManager);
        ServiceTokenManagerTest.assertNull((Object)another.getToken());
        another.init();
        ServiceTokenManagerTest.assertEquals((String)token, (String)another.getToken());
    }

    public void testAcceptedTokenPersists() {
        this.tokenManager.setGenerate(false);
        this.tokenManager.init();
        this.tokenManager.validateToken(TEST_TOKEN);
        ServiceTokenManager another = new ServiceTokenManager();
        another.setConfigurationManager(this.configManager);
        ServiceTokenManagerTest.assertNull((Object)another.getToken());
        another.init();
        ServiceTokenManagerTest.assertEquals((String)TEST_TOKEN, (String)another.getToken());
    }

    public void testTokenRefreshes() {
        this.tokenManager.setGenerate(false);
        this.tokenManager.init();
        this.tokenManager.validateToken(TEST_TOKEN);
        try {
            this.tokenManager.validateToken("test token stringfoo");
            ServiceTokenManagerTest.fail();
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
        this.tokenManager.getTokenFile().delete();
        this.tokenManager.validateToken("test token stringfoo");
        ServiceTokenManagerTest.assertEquals((String)"test token stringfoo", (String)this.tokenManager.getToken());
    }
}

