/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.services;

import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.UserPaths;
import com.zutubi.pulse.services.InvalidTokenException;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;

public class ServiceTokenManager {
    private static final Logger LOG = Logger.getLogger(ServiceTokenManager.class);
    private static final String TOKEN_FILE = "service.token";
    private boolean generate = true;
    private UserPaths paths;
    private String token;

    public void init() {
        File tokenFile = this.getTokenFile();
        if (tokenFile.exists()) {
            try {
                this.token = IOUtils.fileToString((File)tokenFile);
            }
            catch (IOException e) {
                LOG.severe("Unable to read service token: " + tokenFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            }
        } else if (this.generate) {
            this.token = RandomUtils.randomString((int)64);
            this.writeToken();
        }
    }

    public void validateToken(String token) throws InvalidTokenException {
        if (this.token == null && !this.generate) {
            this.token = token;
            this.writeToken();
        }
        if (!token.equals(this.token)) {
            if (!this.generate && this.checkRefreshed(token)) {
                return;
            }
            throw new InvalidTokenException();
        }
    }

    private boolean checkRefreshed(String token) {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            this.token = token;
            this.writeToken();
            return true;
        }
        return false;
    }

    public String getToken() {
        return this.token;
    }

    private void writeToken() {
        File tokenFile = this.getTokenFile();
        try {
            FileSystemUtils.createFile((File)tokenFile, (String)this.token);
        }
        catch (IOException e) {
            LOG.severe("Unable to write token file: " + tokenFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    File getTokenFile() {
        return new File(this.paths.getUserConfigRoot(), TOKEN_FILE);
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.paths = configurationManager.getUserPaths();
    }
}

