/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.NumericalFileRevision;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.p4.P4ErrorDetectingHandler;
import com.zutubi.pulse.scm.p4.P4Server;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class P4CheckoutHandler
extends P4ErrorDetectingHandler {
    private static final Pattern PATTERN = Pattern.compile("(.+)#([0-9]+) - (refreshing|updating|added as|deleted as) (.+)");
    private SCMCheckoutEventHandler handler;

    public P4CheckoutHandler(boolean throwOnStderr, SCMCheckoutEventHandler handler) {
        super(throwOnStderr);
        this.handler = handler;
    }

    public void handleStdout(String line) throws SCMException {
        Matcher m;
        if (this.handler != null && (m = PATTERN.matcher(line)).matches()) {
            NumericalFileRevision fileRevision = new NumericalFileRevision(Long.parseLong(m.group(2)));
            this.handler.fileCheckedOut(new Change(m.group(1), (FileRevision)fileRevision, P4Server.decodeAction(m.group(3))));
        }
    }

    public void checkCancelled() throws SCMCancelledException {
        if (this.handler != null) {
            this.handler.checkCancelled();
        }
    }
}

