/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.filesystem.remote.CachingRemoteFile;
import com.zutubi.pulse.filesystem.remote.RemoteFile;
import com.zutubi.pulse.scm.SCMCachePopulator;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMFileCache;
import com.zutubi.pulse.scm.SCMServer;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingSCMServer
implements SCMServer,
SCMCachePopulator {
    @Override
    public String getUniqueLocation() {
        return this.getLocation();
    }

    @Override
    public boolean requiresRefresh(Revision revision) throws SCMException {
        return this.hasChangedSince(revision);
    }

    @Override
    public RemoteFile getFile(String path) throws SCMException {
        Map<String, CachingRemoteFile> cachedListing = SCMFileCache.getInstance().lookup(this);
        if (cachedListing.containsKey(path)) {
            return cachedListing.get(path);
        }
        throw new SCMException("Path '" + path + "' does not exist");
    }

    @Override
    public List<RemoteFile> getListing(String path) throws SCMException {
        Map<String, CachingRemoteFile> cachedListing = SCMFileCache.getInstance().lookup(this);
        if (cachedListing.containsKey(path)) {
            return cachedListing.get(path).list();
        }
        throw new SCMException("Path '" + path + "' does not exist");
    }

    protected void addToCache(String filename, CachingRemoteFile rootFile, SCMFileCache.CacheItem item) {
        StringTokenizer tokens = new StringTokenizer(filename, "/", false);
        String path = "";
        CachingRemoteFile parent = rootFile;
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            if (path.length() > 0 && !path.endsWith("/")) {
                path = path + "/";
            }
            if (!item.cachedListing.containsKey(path = path + name)) {
                CachingRemoteFile f = new CachingRemoteFile(name, tokens.hasMoreTokens(), parent, path);
                if (parent != null) {
                    parent.addChild(f);
                }
                item.cachedListing.put(path, f);
            }
            parent = item.cachedListing.get(path);
        }
    }
}

