/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.events.AllEventListener;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.logging.LogConfiguration;
import com.zutubi.pulse.logging.LogManager;
import com.zutubi.pulse.logging.Loggers;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConfigurationManager {
    private File logConfigDir;
    private File configDir;
    private LogManager logManager;
    private EventManager eventManager;
    private LogConfiguration logConfig;

    public void init() {
        this.logManager.reset();
        this.logManager.configure(new File(this.configDir, "logging.properties"));
        this.updateConfiguration(this.logConfig.getLoggingLevel());
        final Logger evtLogger = Loggers.getEventLogger();
        this.eventManager.register((EventListener)new AllEventListener(){

            public void handleEvent(Event evt) {
                try {
                    evtLogger.info(evt.toString());
                }
                catch (Throwable t) {
                    evtLogger.info(evt.getClass().getName());
                }
            }
        });
    }

    public boolean isEventLoggingEnabled() {
        Handler[] handlers;
        Logger evtLogger = Loggers.getEventLogger();
        for (Handler h : handlers = evtLogger.getDelegate().getHandlers()) {
            if (h.getLevel() == Level.OFF) continue;
            return true;
        }
        return false;
    }

    public void setEventLoggingEnabled(boolean b) {
        Logger evtLogger = Loggers.getEventLogger();
        Handler[] handlers = evtLogger.getDelegate().getHandlers();
        Level handlerLevel = b ? Level.ALL : Level.OFF;
        for (Handler h : handlers) {
            h.setLevel(handlerLevel);
        }
    }

    public List<String> getAvailableConfigurations() {
        String[] filenames = this.logConfigDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("logging") && name.endsWith(".properties");
            }
        });
        LinkedList<String> configs = new LinkedList<String>();
        for (String filename : filenames) {
            configs.add(filename.substring(8, filename.lastIndexOf(".")));
        }
        return configs;
    }

    public void updateConfiguration(String config) {
        File configFile = new File(this.logConfigDir, "logging." + config + ".properties");
        if (!configFile.isFile() || !configFile.canRead()) {
            return;
        }
        this.logManager.resetLevels();
        this.logManager.configure(configFile);
    }

    public void setSystemPaths(SystemPaths paths) {
        this.configDir = paths.getConfigRoot();
        this.logConfigDir = new File(this.configDir, "logging");
    }

    public void setLogConfiguration(LogConfiguration config) {
        this.logConfig = config;
    }

    public void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

