/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemPaths;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FileHandler
extends Handler {
    private java.util.logging.FileHandler delegate;
    private String pattern;
    private int limit;
    private int count;
    private boolean append;
    private SystemPaths paths;

    public void publish(LogRecord record) {
        this.getDelegate().publish(record);
    }

    public void flush() {
        if (this.delegate != null) {
            this.delegate.flush();
        }
    }

    public void close() throws SecurityException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected void reportError(String msg, Exception ex, int code) {
        this.delegate.getErrorManager().error(msg, ex, code);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setLevel(Level l) {
        super.setLevel(l);
        if (this.delegate != null) {
            this.delegate.setLevel(l);
        }
    }

    public void setFormatter(Formatter f) {
        super.setFormatter(f);
        if (this.delegate != null) {
            this.delegate.setFormatter(f);
        }
    }

    public void setFilter(Filter f) {
        super.setFilter(f);
        if (this.delegate != null) {
            this.delegate.setFilter(f);
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.delegate != null) {
            this.delegate.setEncoding(encoding);
        }
    }

    public void setErrorManager(ErrorManager em) {
        super.setErrorManager(em);
        if (this.delegate != null) {
            this.delegate.setErrorManager(em);
        }
    }

    private synchronized java.util.logging.FileHandler getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = new java.util.logging.FileHandler(this.doSubstitution(this.pattern), this.limit, this.count, this.append);
                this.delegate.setLevel(this.getLevel());
                this.delegate.setFormatter(this.getFormatter());
                this.delegate.setFilter(this.getFilter());
                this.delegate.setEncoding(this.getEncoding());
                this.delegate.setErrorManager(this.getErrorManager());
            }
            catch (IOException e) {
                System.err.println("Failed to initialise file logger. Cause: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        return this.delegate;
    }

    public void setSystemPaths(SystemPaths paths) {
        this.paths = paths;
    }

    public void setConfigurationManager(ConfigurationManager configManager) {
        this.setSystemPaths(configManager.getSystemPaths());
    }

    private String doSubstitution(String pattern) {
        if (pattern == null) {
            return pattern;
        }
        File logRoot = this.paths.getLogRoot();
        StringBuffer buffer = new StringBuffer();
        int ix = 0;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = pattern.charAt(ix);
            }
            if (ch == '%') {
                if (ch2 == '%') {
                    buffer.append(ch2);
                    ++ix;
                    continue;
                }
                if (ch2 == 'l') {
                    if (logRoot.exists() || !logRoot.mkdirs()) {
                        // empty if block
                    }
                    try {
                        buffer.append(logRoot.getCanonicalPath());
                    }
                    catch (IOException e) {
                        buffer.append(logRoot.getAbsolutePath());
                    }
                    ++ix;
                    continue;
                }
                buffer.append(ch);
                buffer.append(ch2);
                ++ix;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

