/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.filesystem.remote;

import com.zutubi.pulse.filesystem.File;

public class RemoteFile
implements File,
Comparable {
    private String name;
    private String path;
    private boolean isDir;
    private RemoteFile parent;
    private String type = "text/plain";

    public RemoteFile(String name, boolean isDirectory, RemoteFile parent, String path) {
        this.name = name;
        this.isDir = isDirectory;
        this.parent = parent;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = path;
    }

    public RemoteFile(boolean isDirectory, RemoteFile parent, String path) {
        this(null, isDirectory, parent, path);
        int index = path.lastIndexOf(47);
        this.name = index == -1 ? path : (index == path.length() ? "" : path.substring(index + 1));
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public File getParentFile() {
        if (this.parent == null) {
            if (this.path.contains("/")) {
                this.parent = new RemoteFile(true, null, this.getParentPath(this.path));
            } else if (this.path.length() > 0) {
                this.parent = new RemoteFile(true, null, "");
            }
        }
        return this.parent;
    }

    private String getParentPath(String path) {
        int index = path.lastIndexOf(47);
        assert (index >= 0);
        return path.substring(0, index);
    }

    public String getMimeType() {
        return this.type;
    }

    public void setMimeType(String type) {
        this.type = type;
    }

    public long length() {
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        return null;
    }

    public int compareTo(Object o) {
        RemoteFile other = (RemoteFile)o;
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.name + (this.isDir ? "/" : "");
    }
}

