/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.filesystem.local;

import com.zutubi.pulse.filesystem.File;
import com.zutubi.pulse.filesystem.FileNotFoundException;
import com.zutubi.pulse.filesystem.FileSystem;
import com.zutubi.pulse.filesystem.FileSystemException;
import com.zutubi.pulse.filesystem.local.LocalFile;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;

public class LocalFileSystem
implements FileSystem {
    private final java.io.File base;

    public LocalFileSystem() {
        this(new java.io.File(""));
    }

    public LocalFileSystem(java.io.File base) {
        this.base = base;
    }

    public InputStream getFileContents(String path) throws FileSystemException {
        return this.internalGetFileContents(new java.io.File(this.base, path));
    }

    private InputStream internalGetFileContents(java.io.File file) throws FileSystemException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            if (!file.isFile()) {
                throw new FileSystemException();
            }
            return new FileInputStream(file);
        }
        catch (java.io.FileNotFoundException e) {
            throw new FileNotFoundException();
        }
    }

    public InputStream getFileContents(File file) throws FileSystemException {
        return this.internalGetFileContents(((LocalFile)file).file);
    }

    public File getFile(String path) throws FileSystemException {
        return new LocalFile(this, new java.io.File(this.base, path));
    }

    public String getMimeType(String path) throws FileSystemException {
        return this.internalGetMimeType(new java.io.File(this.base, path));
    }

    private String internalGetMimeType(java.io.File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return FileSystemUtils.getMimeType((java.io.File)file);
    }

    public String getMimeType(File file) throws FileNotFoundException {
        return this.internalGetMimeType(((LocalFile)file).file);
    }

    public LocalFile[] list(String path) throws FileSystemException {
        return this.internalList(new java.io.File(this.base, path));
    }

    public File[] list(File dir) throws FileSystemException {
        return this.internalList(((LocalFile)dir).file);
    }

    public String getSeparator() {
        return java.io.File.separator;
    }

    private LocalFile[] internalList(java.io.File dir) throws FileSystemException {
        java.io.File[] files;
        if (!dir.exists()) {
            throw new FileNotFoundException();
        }
        if (!dir.isDirectory()) {
            throw new FileSystemException();
        }
        LinkedList<LocalFile> listing = new LinkedList<LocalFile>();
        for (java.io.File file : files = dir.listFiles()) {
            if (file.isHidden()) continue;
            listing.add(new LocalFile(this, file));
        }
        return listing.toArray(new LocalFile[listing.size()]);
    }

    public java.io.File getBase() {
        return this.base;
    }
}

