/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.SystemBootstrapManager;
import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.util.logging.Logger;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartCommand
implements Command {
    private static final Logger LOG = Logger.getLogger(StartCommand.class);
    private static final int UNSPECIFIED = -1;
    private static final String ENV_PULSE_DATA = "PULSE_DATA";
    private static final String ENV_PULSE_CONFIG = "PULSE_CONFIG";
    private int port = -1;
    private String pulseData = null;
    private String contextPath = null;
    private String pulseConfig = null;
    private String bindAddress = null;

    public void setPort(int port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setData(String data) {
        this.pulseData = data;
    }

    public void setConfig(String path) {
        this.pulseConfig = path;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    private void parse(String ... argv) throws ParseException {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"data");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"contextpath");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"bindaddress");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'b'));
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(options, argv, true);
        if (commandLine.hasOption('p')) {
            this.setPort(Integer.parseInt(commandLine.getOptionValue('p')));
        }
        if (commandLine.hasOption('d')) {
            this.setData(commandLine.getOptionValue('d'));
        }
        if (commandLine.hasOption('c')) {
            this.setContextPath(commandLine.getOptionValue('c'));
        }
        if (commandLine.hasOption('f')) {
            this.setConfig(commandLine.getOptionValue('f'));
        }
        if (commandLine.hasOption('b')) {
            this.setBindAddress(commandLine.getOptionValue('b'));
        }
    }

    public int execute(BootContext context) throws ParseException {
        return this.execute(context.getCommandArgv());
    }

    public int execute(String[] argv) throws ParseException {
        this.parse(argv);
        return this.execute();
    }

    public int execute() {
        try {
            if (TextUtils.stringSet((String)this.pulseData)) {
                System.setProperty("pulse.data", this.pulseData);
            } else if (TextUtils.stringSet((String)System.getenv(ENV_PULSE_DATA))) {
                System.setProperty("pulse.data", System.getenv(ENV_PULSE_DATA));
            }
            if (TextUtils.stringSet((String)this.pulseConfig)) {
                System.setProperty("pulse.config", this.pulseConfig);
            } else if (TextUtils.stringSet((String)System.getenv(ENV_PULSE_CONFIG))) {
                System.setProperty("pulse.config", System.getenv(ENV_PULSE_CONFIG));
            }
            if (this.port != -1) {
                System.setProperty("webapp.port", Integer.toString(this.port));
            }
            if (TextUtils.stringSet((String)this.contextPath)) {
                System.setProperty("webapp.contextPath", this.contextPath);
            }
            if (TextUtils.stringSet((String)this.bindAddress)) {
                System.setProperty("webapp.bindAddress", this.bindAddress);
            }
            SystemBootstrapManager bootstrap = new SystemBootstrapManager();
            bootstrap.bootstrapSystem();
            return 0;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return 1;
        }
    }

    public String getHelp() {
        return "start the pulse server";
    }

    public String getDetailedHelp() {
        return "Starts the pulse server, running in this console.  A message will be printed\nwhen the server has started and the web interface is available.";
    }

    public List<String> getUsages() {
        return Arrays.asList("");
    }

    public List<String> getAliases() {
        return Arrays.asList("st");
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-p [--port] port", "the port to be used by the pulse web interface");
        options.put("-d [--data] dir", "use the specified directory for all pulse data");
        options.put("-c [--contextpath] path", "the pulse web application context path");
        options.put("-b [--bindaddress] addr", "the address to bind the server to");
        options.put("-f [--config] file", "specify an alternate config file");
        return options;
    }

    public boolean isDefault() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        StartCommand cmd = new StartCommand();
        cmd.execute(args);
    }
}

