/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.AdminCommand;
import com.zutubi.pulse.command.BootContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownCommand
extends AdminCommand {
    private boolean force;
    private boolean exitJvm = true;

    public void setForce(boolean b) {
        this.force = b;
    }

    public void setExitJvm(boolean exitJvm) {
        this.exitJvm = exitJvm;
    }

    private void parse(String ... argv) throws ParseException {
        Options options = this.getSharedOptions();
        options.addOption(new Option("F", "force", false, "force shutdown"));
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(options, argv, true);
        this.setForce(commandLine.hasOption('F'));
        this.processSharedOptions(commandLine);
    }

    public String getHelp() {
        return "shutdown the pulse server";
    }

    public String getDetailedHelp() {
        return "Triggers a shutdown of a local pulse server.  By default, the shutdown is\n'clean': i.e. pulse will wait for running builds to complete.  This may be\noverriden with the --force option, which causes builds to be aborted.";
    }

    public List<String> getAliases() {
        return Arrays.asList("sd", "shut", "stop");
    }

    @Override
    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-F [--force]", "force an immediate shutdown, aborting running builds");
        options.putAll(super.getOptions());
        return options;
    }

    @Override
    public int doExecute(BootContext context) throws XmlRpcException, IOException, ParseException {
        this.parse(context.getCommandArgv());
        return this.execute();
    }

    public int execute() throws XmlRpcException, IOException {
        this.xmlRpcClient.execute("RemoteApi.shutdown", new Vector<Object>(Arrays.asList(this.adminToken, this.force, this.exitJvm)));
        return 0;
    }

    public static void main(String[] argv) {
        ShutdownCommand command = new ShutdownCommand();
        try {
            command.parse(argv);
            command.execute(new BootContext(null, argv, null, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

