/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.api.AdminTokenManager;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemBootstrapManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.config.FileConfig;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminCommand
implements Command {
    protected XmlRpcClient xmlRpcClient;
    protected String adminToken;
    private int port = -1;
    private String contextPath;
    private static final String ENV_PULSE_CONFIG = "PULSE_CONFIG";
    private String pulseConfig;

    private String loadAdminToken(ConfigurationManager configurationManager) throws IOException {
        File tokenFile = AdminTokenManager.getAdminTokenFilename(configurationManager.getSystemPaths().getConfigRoot());
        if (tokenFile.exists()) {
            return IOUtils.fileToString((File)tokenFile);
        }
        return null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setConfig(String path) {
        this.pulseConfig = path;
    }

    public int execute(BootContext context) throws ParseException, IOException {
        URL url;
        if (TextUtils.stringSet((String)this.pulseConfig)) {
            System.setProperty("pulse.config", this.pulseConfig);
        } else if (TextUtils.stringSet((String)System.getenv(ENV_PULSE_CONFIG))) {
            System.setProperty("pulse.config", System.getenv(ENV_PULSE_CONFIG));
        }
        SystemBootstrapManager sbm = new SystemBootstrapManager();
        sbm.loadBootstrapContext();
        ConfigurationManager configurationManager = (ConfigurationManager)ComponentContext.getBean("configurationManager");
        try {
            File configRoot = configurationManager.getSystemPaths().getConfigRoot();
            SystemConfiguration config = configurationManager.getSystemConfig();
            File startupConfigFile = new File(configRoot, "runtime.properties");
            ConfigSupport sysConfig = new ConfigSupport((Config)new FileConfig(startupConfigFile));
            int webPort = sysConfig.getInteger("webapp.port", Integer.valueOf(config.getServerPort()));
            if (this.port != -1) {
                webPort = this.port;
            }
            String path = sysConfig.getProperty("webapp.contextPath", config.getContextPath());
            if (TextUtils.stringSet((String)this.contextPath)) {
                path = this.contextPath;
            }
            StringBuffer remoteApiPath = new StringBuffer();
            if (!path.startsWith("/")) {
                remoteApiPath.append("/");
            }
            remoteApiPath.append(path);
            if (!remoteApiPath.toString().endsWith("/")) {
                remoteApiPath.append("/");
            }
            remoteApiPath.append("xmlrpc");
            url = new URL("http", "127.0.0.1", webPort, remoteApiPath.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return 1;
        }
        this.xmlRpcClient = new XmlRpcClient(url);
        try {
            this.adminToken = this.loadAdminToken(configurationManager);
            return this.doExecute(context);
        }
        catch (IOException e) {
            System.err.println("I/O Error: " + e.getMessage());
            return 1;
        }
        catch (XmlRpcException e) {
            System.err.println("Unable to send command to server: " + e.getMessage());
            return 1;
        }
    }

    public List<String> getUsages() {
        return Arrays.asList("");
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-p [--port] port", "the port to be used by the pulse web interface");
        options.put("-c [--contextPath] path", "the pulse web application context path");
        options.put("-f [--config] file", "specify an alternate config file");
        return options;
    }

    public boolean isDefault() {
        return false;
    }

    public abstract int doExecute(BootContext var1) throws XmlRpcException, IOException, ParseException;

    protected Options getSharedOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"contextpath");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        return options;
    }

    protected void processSharedOptions(CommandLine commandLine) {
        if (commandLine.hasOption('p')) {
            this.setPort(Integer.parseInt(commandLine.getOptionValue('p')));
        }
        if (commandLine.hasOption('c')) {
            this.setContextPath(commandLine.getOptionValue('c'));
        }
        if (commandLine.hasOption('f')) {
            this.setConfig(commandLine.getOptionValue('f'));
        }
    }
}

