/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap.conf;

import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.util.FileSystemUtils;

public class EnvConfig
extends ConfigSupport {
    public static final String PULSE_HOME = "pulse.home";
    public static final String VERSION_HOME = "pulse.version.home";
    public static final String PULSE_CONFIG = "pulse.config";
    public static final String USER_HOME = "user.home";
    private String defaultConfig;
    private String defaultConfigDir;

    public EnvConfig(Config props) {
        super(props);
    }

    public boolean isWriteable() {
        return false;
    }

    public String getPulseHome() {
        return this.getProperty(PULSE_HOME);
    }

    public boolean hasPulseHome() {
        return this.hasProperty(PULSE_HOME);
    }

    public String getVersionHome() {
        return this.getProperty(VERSION_HOME);
    }

    public boolean hasVersionHome() {
        return this.hasProperty(VERSION_HOME);
    }

    public String getPulseConfig() {
        return this.getProperty(PULSE_CONFIG);
    }

    public boolean hasPulseConfig() {
        return this.hasProperty(PULSE_CONFIG);
    }

    public String getDefaultPulseConfigDir(String base) {
        if (this.defaultConfigDir == null) {
            this.defaultConfigDir = FileSystemUtils.composeFilename((String[])new String[]{this.getUserHome(), base});
        }
        return this.defaultConfigDir;
    }

    public String getDefaultPulseConfig(String base) {
        if (this.defaultConfig == null) {
            this.defaultConfig = FileSystemUtils.composeFilename((String[])new String[]{this.getDefaultPulseConfigDir(base), "config.properties"});
        }
        return this.defaultConfig;
    }

    public String getUserHome() {
        return this.getProperty(USER_HOME);
    }
}

