/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.config.CompositeConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SystemConfigurationSupport
extends ConfigSupport
implements SystemConfiguration {
    public SystemConfigurationSupport(Config ... config) {
        super((Config)new CompositeConfig(config));
    }

    public String getBindAddress() {
        String result = this.config.getProperty("webapp.bindAddress");
        if (TextUtils.stringSet((String)result)) {
            return result;
        }
        return "0.0.0.0";
    }

    public int getServerPort() {
        return this.getInteger("webapp.port", 8080);
    }

    public String getContextPath() {
        return this.getProperty("webapp.contextPath", "/");
    }

    public void setDataPath(String path) {
        this.setProperty("pulse.data", path);
    }

    public String getDataPath() {
        return this.getProperty("pulse.data");
    }

    public String getHostUrl() {
        String hostname = "localhost";
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        String hostUrl = "http://" + hostname + ":" + this.getServerPort();
        if (!this.getContextPath().startsWith("/")) {
            hostUrl = hostUrl + "/";
        }
        return hostUrl + this.getContextPath();
    }
}

