/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.SystemPaths;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSystemPaths
implements SystemPaths {
    private final File pulseHome;
    private final File versionHome;
    private File systemRoot;
    private File contentRoot;
    private File configRoot;
    private File logRoot;
    private List<File> templateRoots;
    private File tmpRoot;

    public DefaultSystemPaths(File pulseHome, File versionHome) {
        this.pulseHome = pulseHome;
        this.versionHome = versionHome;
    }

    @Override
    public File getSystemRoot() {
        if (this.systemRoot == null) {
            this.systemRoot = new File(this.versionHome, "system");
        }
        return this.systemRoot;
    }

    @Override
    public File getContentRoot() {
        if (this.contentRoot == null) {
            this.contentRoot = new File(this.getSystemRoot(), "www");
        }
        return this.contentRoot;
    }

    @Override
    public File getConfigRoot() {
        if (this.configRoot == null) {
            this.configRoot = new File(this.getSystemRoot(), "config");
        }
        return this.configRoot;
    }

    @Override
    public File getLogRoot() {
        if (this.logRoot == null) {
            this.logRoot = new File(this.pulseHome, "logs");
        }
        return this.logRoot;
    }

    @Override
    public List<File> getTemplateRoots() {
        if (this.templateRoots == null) {
            this.templateRoots = new LinkedList<File>();
            this.templateRoots.add(new File(this.getSystemRoot(), "templates"));
            this.templateRoots.add(new File(this.getSystemRoot(), "www"));
        }
        return this.templateRoots;
    }

    @Override
    public File getTmpRoot() {
        if (this.tmpRoot == null) {
            this.tmpRoot = new File(this.getSystemRoot(), "tmp");
        }
        return this.tmpRoot;
    }
}

