/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.spring.SpringAutowireSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContext {
    private static ConfigurableApplicationContext context = null;

    public static ApplicationContext getContext() {
        return context;
    }

    public static void addFileContextDefinitions(String ... definitions) {
        if (definitions != null && definitions.length > 0) {
            FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(definitions, false, (ApplicationContext)context);
            ComponentContext.publishContext((ConfigurableApplicationContext)ctx);
        }
    }

    public static void addClassPathContextDefinitions(String ... definitions) {
        if (definitions != null && definitions.length > 0) {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(definitions, false, (ApplicationContext)context);
            ComponentContext.publishContext((ConfigurableApplicationContext)ctx);
        }
    }

    public static void pop() {
        ConfigurableApplicationContext top = context;
        context = (ConfigurableApplicationContext)context.getParent();
        top.setParent(null);
        top.close();
    }

    private static void publishContext(ConfigurableApplicationContext newContext) {
        newContext.refresh();
        context = newContext;
    }

    public static Object getBean(String name) {
        if (ComponentContext.getContext() != null) {
            return ComponentContext.getContext().getBean(name);
        }
        return null;
    }

    public static void autowire(Object bean) {
        if (ComponentContext.getContext() == null) {
            return;
        }
        SpringAutowireSupport support = new SpringAutowireSupport();
        support.setApplicationContext((ApplicationContext)context);
        support.autoWireBean(bean);
    }

    public static <U> U createBean(Class beanClass) throws Exception {
        SpringAutowireSupport support = new SpringAutowireSupport();
        support.setApplicationContext((ApplicationContext)context);
        return (U)support.createWiredBean(beanClass);
    }

    public static void closeAll() {
        if (ComponentContext.getContext() != null) {
            for (ConfigurableApplicationContext ctx = context; ctx != null; ctx = (ConfigurableApplicationContext)ctx.getParent()) {
                ctx.close();
            }
            context = null;
        }
    }
}

