/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.DefaultSystemPaths;
import com.zutubi.pulse.bootstrap.StartupException;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.bootstrap.conf.EnvConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.PropertiesConfig;
import java.io.File;

public abstract class AbstractConfigurationManager
implements ConfigurationManager {
    private SystemPaths systemPaths = null;
    protected EnvConfig envConfig;

    public EnvConfig getEnvConfig() {
        if (this.envConfig == null) {
            this.envConfig = new EnvConfig((Config)new PropertiesConfig(System.getProperties()));
        }
        return this.envConfig;
    }

    public SystemPaths getSystemPaths() {
        if (this.systemPaths == null) {
            File pulseHome = this.getHomeDir(this.getEnvConfig().getPulseHome(), "pulse.home");
            File versionHome = this.getHomeDir(this.getEnvConfig().getVersionHome(), "pulse.version.home");
            this.systemPaths = new DefaultSystemPaths(pulseHome, versionHome);
        }
        return this.systemPaths;
    }

    private File getHomeDir(String home, String property) {
        if (home == null || home.length() == 0) {
            throw new StartupException("Required property '" + property + "' is not set");
        }
        File homeDir = new File(home);
        if (!homeDir.exists() || !homeDir.isDirectory()) {
            throw new StartupException("Property '" + property + "' does not refer to a " + "directory ('" + home + ")");
        }
        return homeDir;
    }

    public void setSystemPaths(SystemPaths paths) {
        this.systemPaths = paths;
    }
}

