/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.Startup;
import com.zutubi.pulse.bootstrap.conf.EnvConfig;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class SystemInfo {
    private Properties systemProperties;
    private Properties paths;
    private Version version;
    private long totalMemory;
    private long usedMemory;
    private long freeMemory;

    public static SystemInfo getSystemInfo(ConfigurationManager configurationManager, Startup startupManager) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("EEEEE, dd MMM yyyy");
        SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss z");
        SystemInfo info = new SystemInfo();
        info.paths = new Properties();
        EnvConfig envConfig = configurationManager.getEnvConfig();
        String pulseHome = envConfig.getPulseHome();
        if (pulseHome != null) {
            info.paths.put("pulse.homeDir.field", pulseHome);
        }
        info.paths.put("pulse.dataDir.field", configurationManager.getUserPaths().getData());
        Properties properties = System.getProperties();
        info.systemProperties = new Properties();
        info.systemProperties.putAll((Map<?, ?>)properties);
        info.systemProperties.put("system.date", dateFormatter.format(new Date()));
        info.systemProperties.put("system.time", timeFormatter.format(new Date()));
        info.systemProperties.put("system.uptime", SystemInfo.formatUptime(startupManager.getUptime()));
        info.systemProperties.put("os.name", properties.getProperty("os.name") + " " + properties.getProperty("os.version"));
        info.totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        info.freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        info.usedMemory = info.totalMemory - info.freeMemory;
        info.systemProperties.put("memory.used", (Object)info.usedMemory);
        info.systemProperties.put("memory.free", (Object)info.freeMemory);
        info.systemProperties.put("memory.total", (Object)info.totalMemory);
        info.version = Version.getVersion();
        return info;
    }

    private static String formatUptime(long uptime) {
        StringBuffer buffer = new StringBuffer();
        String sep = "";
        long days = uptime / 86400000L;
        if (days > 0L) {
            buffer.append(sep).append(days).append(" day").append(days != 1L ? "s" : "");
            sep = " ";
        }
        long hours = uptime % 86400000L / 3600000L;
        long minutes = uptime % 86400000L % 3600000L / 60000L;
        long seconds = uptime % 86400000L % 3600000L % 60000L / 1000L;
        buffer.append(sep).append(MessageFormat.format("{0,number,00}:{1,number,00}:{2,number,00}", hours, minutes, seconds));
        return buffer.toString();
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Properties getPaths() {
        return this.paths;
    }

    public Version getVersion() {
        return this.version;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }
}

