/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.Stoppable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownManager {
    private List<Stoppable> stoppables;
    private static final int EXIT_REBOOT = 111;
    private boolean shuttingDown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean force, boolean exitJvm) {
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        try {
            this.doShutdown(force, exitJvm);
        }
        finally {
            shutdownManager = this;
            synchronized (shutdownManager) {
                this.shuttingDown = false;
            }
        }
    }

    private void doShutdown(boolean force, boolean exitJvm) {
        if (this.checkWrapper(0)) {
            return;
        }
        this.stop(force);
        if (exitJvm) {
            System.exit(0);
        } else {
            ComponentContext.closeAll();
        }
    }

    public void stop(boolean force) {
        for (Stoppable stoppable : this.stoppables) {
            stoppable.stop(force);
        }
    }

    public boolean checkWrapper(int exitCode) {
        try {
            Class<?> wrapperManagerClass = Class.forName("org.tanukisoftware.wrapper.WrapperManager");
            try {
                Method stopMethod = wrapperManagerClass.getMethod("stop", Integer.TYPE);
                stopMethod.invoke(null, exitCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void delayedShutdown(boolean force, boolean exitJvm) {
        ShutdownRunner runner = new ShutdownRunner(force, exitJvm);
        new Thread(runner).start();
    }

    public void delayedStop() {
        StopRunner runner = new StopRunner();
        new Thread(runner).start();
    }

    public void setStoppables(List<Stoppable> stoppables) {
        this.stoppables = stoppables;
    }

    public void addStoppable(Stoppable stoppable) {
        if (this.stoppables == null) {
            this.stoppables = new LinkedList<Stoppable>();
        }
        this.stoppables.add(stoppable);
    }

    public void reboot() {
        if (!this.checkWrapper(111)) {
            this.stop(true);
            System.exit(111);
        }
    }

    private class StopRunner
    implements Runnable {
        private StopRunner() {
        }

        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ShutdownManager.this.stop(true);
        }
    }

    private class ShutdownRunner
    implements Runnable {
        private boolean force;
        private boolean exitJvm;

        public ShutdownRunner(boolean force, boolean exitJvm) {
            this.force = force;
            this.exitJvm = exitJvm;
        }

        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ShutdownManager.this.shutdown(this.force, this.exitJvm);
        }
    }
}

