/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ServerRecipePaths
implements RecipePaths {
    private long id;
    private File dataDir;
    private String project;
    private String spec;
    private boolean incremental;

    public ServerRecipePaths(String project, String spec, long id, File dataDir, boolean incremental) {
        this.project = project;
        this.spec = spec;
        this.id = id;
        this.dataDir = dataDir;
        this.incremental = incremental;
    }

    private File getRecipesRoot() {
        return new File(this.dataDir, "recipes");
    }

    public File getRecipeRoot() {
        return new File(this.getRecipesRoot(), Long.toString(this.id));
    }

    public File getPersistentWorkDir() {
        return new File(this.dataDir, FileSystemUtils.composeFilename((String[])new String[]{"work", this.encode(this.project), this.encode(this.spec)}));
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public File getBaseDir() {
        if (this.incremental) {
            return this.getPersistentWorkDir();
        }
        return new File(this.getRecipeRoot(), "base");
    }

    public File getOutputDir() {
        return new File(this.getRecipeRoot(), "output");
    }

    public File getBaseZip() {
        return new File(this.getBaseDir().getAbsolutePath() + ".zip");
    }

    public File getOutputZip() {
        return new File(this.getOutputDir().getAbsolutePath() + ".zip");
    }
}

