/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.util.ForkOutputStream;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;

public abstract class ScmBootstrapper
implements Bootstrapper,
SCMCheckoutEventHandler {
    private static final Logger LOG = Logger.getLogger(ScmBootstrapper.class);
    protected String agent;
    protected String project;
    protected String spec;
    protected Scm scm;
    protected BuildRevision revision;
    protected boolean terminated = false;
    protected transient PrintWriter outputWriter;

    public ScmBootstrapper(String project, String spec, Scm scm, BuildRevision revision) {
        this.project = project;
        this.spec = spec;
        this.scm = scm;
        this.revision = revision;
    }

    public void prepare(String agent) {
        this.agent = agent;
    }

    public void bootstrap(CommandContext context) {
        File workDir = this.scm.getPath() != null ? new File(context.getPaths().getBaseDir(), this.scm.getPath()) : context.getPaths().getBaseDir();
        File outDir = new File(context.getOutputDir(), "bootstrap output");
        outDir.mkdirs();
        FileOutputStream out = null;
        FileOutputStream fout = null;
        SCMServer server = null;
        try {
            fout = new FileOutputStream(new File(outDir, "files.txt"));
            out = context.getOutputStream() == null ? fout : new ForkOutputStream(new OutputStream[]{fout, context.getOutputStream()});
            this.outputWriter = new PrintWriter(out);
            server = this.bootstrap(workDir);
        }
        catch (IOException e) {
            throw new BuildException("I/O error running bootstrap: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)this.outputWriter);
        }
        if (server != null) {
            try {
                server.writeConnectionDetails(outDir);
                for (Map.Entry<String, String> entry : server.getConnectionProperties(this.getId(), workDir).entrySet()) {
                    context.getGlobalScope().add(new ResourceProperty(entry.getKey(), entry.getValue(), true, false, false));
                }
            }
            catch (Exception e) {
                LOG.warning("Unable to capture SCM connection details: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getId() {
        return this.project + "-" + this.spec + "-" + this.agent;
    }

    public void status(String message) {
        this.outputWriter.println(message);
    }

    public void fileCheckedOut(Change change) {
        String revision = "";
        if (change.getRevision() != null) {
            revision = "#" + change.getRevision();
        }
        this.outputWriter.println(change.getFilename() + revision + " - " + change.getAction().toString());
    }

    public void checkCancelled() throws SCMCancelledException {
        if (this.terminated) {
            throw new SCMCancelledException("Operation cancelled");
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    abstract SCMServer bootstrap(File var1);
}

