/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.CheckoutBootstrapper;
import com.zutubi.pulse.ScmBootstrapper;
import com.zutubi.pulse.UpdateBootstrapper;
import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.io.IOException;

public class ProjectRepoBootstrapper
implements Bootstrapper {
    private final String projectName;
    private final String specName;
    private final Scm scm;
    private BuildRevision revision;
    private String agent;
    private boolean forceClean;
    private ScmBootstrapper childBootstrapper;

    public ProjectRepoBootstrapper(String projectName, String specName, Scm scm, BuildRevision revision, boolean forceClean) {
        this.projectName = projectName;
        this.specName = specName;
        this.scm = scm;
        this.revision = revision;
        this.forceClean = forceClean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(CommandContext context) throws BuildException {
        final RecipePaths paths = context.getPaths();
        if (paths.getPersistentWorkDir() == null) {
            throw new BuildException("Attempt to use update bootstrapping when no persistent working directory is available.");
        }
        this.childBootstrapper = this.selectBootstrapper(paths.getPersistentWorkDir());
        this.childBootstrapper.prepare(this.agent);
        RecipePaths mungedPaths = new RecipePaths(){

            public File getPersistentWorkDir() {
                return paths.getPersistentWorkDir();
            }

            public File getBaseDir() {
                return paths.getPersistentWorkDir();
            }

            public File getOutputDir() {
                return paths.getOutputDir();
            }
        };
        context.setRecipePaths(mungedPaths);
        try {
            this.childBootstrapper.bootstrap(context);
        }
        finally {
            context.setRecipePaths(paths);
        }
        if (!paths.getBaseDir().equals(paths.getPersistentWorkDir())) {
            try {
                FileSystemUtils.copy((File)paths.getBaseDir(), (File[])new File[]{paths.getPersistentWorkDir()});
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void prepare(String agent) {
        this.agent = agent;
    }

    public void terminate() {
        if (this.childBootstrapper != null) {
            this.childBootstrapper.terminate();
        }
    }

    private ScmBootstrapper selectBootstrapper(File localDir) {
        if (this.forceClean && localDir.exists() && !FileSystemUtils.rmdir((File)localDir)) {
            throw new BuildException("Unable to remove local scm directory: " + localDir.getAbsolutePath());
        }
        if (!localDir.exists() && !localDir.mkdirs()) {
            throw new BuildException("Failed to initialise local scm directory: " + localDir.getAbsolutePath());
        }
        if (localDir.list().length == 0) {
            return new CheckoutBootstrapper(this.projectName, this.specName, this.scm, this.revision, true);
        }
        return new UpdateBootstrapper(this.projectName, this.specName, this.scm, this.revision);
    }
}

