/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.core.BootstrapperSupport;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;

public class CopyBootstrapper
extends BootstrapperSupport {
    private String url;
    private long previousRecipeId;
    private String token;

    public CopyBootstrapper(String url, String token, long previousRecipeId) {
        this.url = url;
        this.token = token;
        this.previousRecipeId = previousRecipeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(CommandContext context) throws BuildException {
        try {
            URL resultUrl = new URL(this.url + "/download?token=" + this.token + "&output=false&recipe=" + this.previousRecipeId);
            URLConnection urlConnection = resultUrl.openConnection();
            FileOutputStream zos = null;
            File zipName = new File(context.getPaths().getBaseDir().getAbsolutePath() + ".zip");
            try {
                zos = new FileOutputStream(zipName);
                IOUtils.joinStreams((InputStream)urlConnection.getInputStream(), (OutputStream)zos);
            }
            finally {
                IOUtils.close((Closeable)urlConnection.getInputStream());
                IOUtils.close((Closeable)zos);
            }
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new FileInputStream(zipName));
                FileSystemUtils.extractZip((ZipInputStream)zis, (File)context.getPaths().getBaseDir());
            }
            catch (Throwable throwable) {
                IOUtils.close(zis);
                throw throwable;
            }
            IOUtils.close((Closeable)zis);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new BuildException("Bootstrapping working directory from '" + this.url + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

