/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class Roster {
    public static final int SUBSCRIPTION_ACCEPT_ALL = 0;
    public static final int SUBSCRIPTION_REJECT_ALL = 1;
    public static final int SUBSCRIPTION_MANUAL = 2;
    private static int defaultSubscriptionMode = 0;
    private XMPPConnection connection;
    private Map groups;
    private List entries;
    private List unfiledEntries;
    private List rosterListeners;
    private Map presenceMap;
    boolean rosterInitialized = false;
    private int subscriptionMode = Roster.getDefaultSubscriptionMode();
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$RosterPacket;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Presence;

    public static int getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(int subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    Roster(XMPPConnection connection) {
        this.connection = connection;
        this.groups = new Hashtable();
        this.unfiledEntries = new ArrayList();
        this.entries = new ArrayList();
        this.rosterListeners = new ArrayList();
        this.presenceMap = new HashMap();
        PacketTypeFilter rosterFilter = new PacketTypeFilter(class$org$jivesoftware$smack$packet$RosterPacket == null ? (class$org$jivesoftware$smack$packet$RosterPacket = Roster.class$("org.jivesoftware.smack.packet.RosterPacket")) : class$org$jivesoftware$smack$packet$RosterPacket);
        connection.addPacketListener(new RosterPacketListener(), rosterFilter);
        PacketTypeFilter presenceFilter = new PacketTypeFilter(class$org$jivesoftware$smack$packet$Presence == null ? (class$org$jivesoftware$smack$packet$Presence = Roster.class$("org.jivesoftware.smack.packet.Presence")) : class$org$jivesoftware$smack$packet$Presence);
        connection.addPacketListener(new PresencePacketListener(), presenceFilter);
    }

    public int getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(int subscriptionMode) {
        if (subscriptionMode != 0 && subscriptionMode != 1 && subscriptionMode != 2) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() {
        this.connection.sendPacket(new RosterPacket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterListener(RosterListener rosterListener) {
        List list = this.rosterListeners;
        synchronized (list) {
            if (!this.rosterListeners.contains(rosterListener)) {
                this.rosterListeners.add(rosterListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterListener(RosterListener rosterListener) {
        List list = this.rosterListeners;
        synchronized (list) {
            this.rosterListeners.remove(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterGroup createGroup(String name) {
        Map map = this.groups;
        synchronized (map) {
            if (this.groups.containsKey(name)) {
                throw new IllegalArgumentException("Group with name " + name + " alread exists.");
            }
            RosterGroup group = new RosterGroup(name, this.connection);
            this.groups.put(name, group);
            return group;
        }
    }

    public void createEntry(String user, String name, String[] groups) throws XMPPException {
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] == null) continue;
                item.addGroupName(groups[i]);
            }
        }
        rosterPacket.addRosterItem(item);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
        this.connection.sendPacket(rosterPacket);
        IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        Presence presencePacket = new Presence(Presence.Type.SUBSCRIBE);
        presencePacket.setTo(user);
        this.connection.sendPacket(presencePacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry entry) throws XMPPException {
        List list = this.entries;
        synchronized (list) {
            if (!this.entries.contains(entry)) {
                return;
            }
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.SET);
        RosterPacket.Item item = RosterEntry.toRosterItem(entry);
        item.setItemType(RosterPacket.ItemType.REMOVE);
        packet.addRosterItem(item);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(packet.getPacketID()));
        this.connection.sendPacket(packet);
        IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        HashMap entryMap = new HashMap();
        Iterator groups = this.getGroups();
        while (groups.hasNext()) {
            RosterGroup rosterGroup = (RosterGroup)groups.next();
            Iterator entries = rosterGroup.getEntries();
            while (entries.hasNext()) {
                entryMap.put(entries.next(), "");
            }
        }
        List list = this.unfiledEntries;
        synchronized (list) {
            return entryMap.size() + this.unfiledEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEntries() {
        ArrayList<RosterEntry> allEntries = new ArrayList<RosterEntry>();
        Iterator groups = this.getGroups();
        while (groups.hasNext()) {
            RosterGroup rosterGroup = (RosterGroup)groups.next();
            Iterator entries = rosterGroup.getEntries();
            while (entries.hasNext()) {
                RosterEntry entry = (RosterEntry)entries.next();
                if (allEntries.contains(entry)) continue;
                allEntries.add(entry);
            }
        }
        List list = this.unfiledEntries;
        synchronized (list) {
            allEntries.addAll(this.unfiledEntries);
        }
        return allEntries.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnfiledEntryCount() {
        List list = this.unfiledEntries;
        synchronized (list) {
            return this.unfiledEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getUnfiledEntries() {
        List list = this.unfiledEntries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.unfiledEntries)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        String userLowerCase = user.toLowerCase();
        List list = this.entries;
        synchronized (list) {
            Iterator i = this.entries.iterator();
            while (i.hasNext()) {
                RosterEntry entry = (RosterEntry)i.next();
                if (!entry.getUser().equals(userLowerCase)) continue;
                return entry;
            }
        }
        return null;
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterGroup getGroup(String name) {
        Map map = this.groups;
        synchronized (map) {
            return (RosterGroup)this.groups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() {
        Map map = this.groups;
        synchronized (map) {
            return this.groups.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGroups() {
        Map map = this.groups;
        synchronized (map) {
            List groupsList = Collections.unmodifiableList(new ArrayList(this.groups.values()));
            return groupsList.iterator();
        }
    }

    public Presence getPresence(String user) {
        String key = this.getPresenceMapKey(user);
        Map userPresences = (Map)this.presenceMap.get(key);
        if (userPresences == null) {
            return null;
        }
        Iterator it = userPresences.keySet().iterator();
        Presence presence = null;
        while (it.hasNext()) {
            Presence p = (Presence)userPresences.get(it.next());
            if (presence == null) {
                presence = p;
                continue;
            }
            if (p.getPriority() <= presence.getPriority()) continue;
            presence = p;
        }
        return presence;
    }

    public Presence getPresenceResource(String userResource) {
        String key = this.getPresenceMapKey(userResource);
        String resource = StringUtils.parseResource(userResource);
        Map userPresences = (Map)this.presenceMap.get(key);
        if (userPresences == null) {
            return null;
        }
        return (Presence)userPresences.get(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getPresences(String user) {
        String key = this.getPresenceMapKey(user);
        Map userPresences = (Map)this.presenceMap.get(key);
        if (userPresences == null) {
            return null;
        }
        Map map = userPresences;
        synchronized (map) {
            return new HashMap(userPresences).values().iterator();
        }
    }

    private String getPresenceMapKey(String user) {
        if (user == null) {
            return null;
        }
        String key = user;
        if (!this.contains(user)) {
            key = StringUtils.parseBareAddress(user);
        }
        return key.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterChangedEvent(Collection addedEntries, Collection updatedEntries, Collection deletedEntries) {
        RosterListener[] listeners;
        List list = this.rosterListeners;
        synchronized (list) {
            listeners = new RosterListener[this.rosterListeners.size()];
            this.rosterListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!addedEntries.isEmpty()) {
                listeners[i].entriesAdded(addedEntries);
            }
            if (!updatedEntries.isEmpty()) {
                listeners[i].entriesUpdated(updatedEntries);
            }
            if (deletedEntries.isEmpty()) continue;
            listeners[i].entriesDeleted(deletedEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterPresenceEvent(String user) {
        RosterListener[] listeners;
        List list = this.rosterListeners;
        synchronized (list) {
            listeners = new RosterListener[this.rosterListeners.size()];
            this.rosterListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].presenceChanged(user);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RosterPacketListener
    implements PacketListener {
        private RosterPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            ArrayList<String> addedEntries = new ArrayList<String>();
            ArrayList<String> updatedEntries = new ArrayList<String>();
            ArrayList<String> deletedEntries = new ArrayList<String>();
            RosterPacket rosterPacket = (RosterPacket)packet;
            Iterator i = rosterPacket.getRosterItems();
            while (i.hasNext()) {
                RosterPacket.Item item = (RosterPacket.Item)i.next();
                RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this.connection);
                if (RosterPacket.ItemType.REMOVE.equals(item.getItemType())) {
                    if (Roster.this.entries.contains(entry)) {
                        Roster.this.entries.remove(entry);
                    }
                    List list = Roster.this.unfiledEntries;
                    synchronized (list) {
                        if (Roster.this.unfiledEntries.contains(entry)) {
                            Roster.this.unfiledEntries.remove(entry);
                        }
                    }
                    String key = StringUtils.parseName(item.getUser()) + "@" + StringUtils.parseServer(item.getUser());
                    Roster.this.presenceMap.remove(key);
                    deletedEntries.add(item.getUser());
                } else {
                    Object existingEntry;
                    if (!Roster.this.entries.contains(entry)) {
                        Roster.this.entries.add(entry);
                        addedEntries.add(item.getUser());
                    } else {
                        existingEntry = (RosterEntry)Roster.this.entries.get(Roster.this.entries.indexOf(entry));
                        ((RosterEntry)existingEntry).updateState(entry.getName(), entry.getType(), entry.getStatus());
                        updatedEntries.add(item.getUser());
                    }
                    if (item.getGroupNames().hasNext()) {
                        existingEntry = Roster.this.unfiledEntries;
                        synchronized (existingEntry) {
                            Roster.this.unfiledEntries.remove(entry);
                        }
                    }
                    existingEntry = Roster.this.unfiledEntries;
                    synchronized (existingEntry) {
                        if (!Roster.this.unfiledEntries.contains(entry)) {
                            Roster.this.unfiledEntries.add(entry);
                        }
                    }
                }
                ArrayList<String> currentGroupNames = new ArrayList<String>();
                Iterator j = entry.getGroups();
                while (j.hasNext()) {
                    RosterGroup group = (RosterGroup)j.next();
                    currentGroupNames.add(group.getName());
                }
                if (!RosterPacket.ItemType.REMOVE.equals(item.getItemType())) {
                    ArrayList<String> newGroupNames = new ArrayList<String>();
                    Iterator k = item.getGroupNames();
                    while (k.hasNext()) {
                        String groupName = (String)k.next();
                        newGroupNames.add(groupName);
                        RosterGroup group = Roster.this.getGroup(groupName);
                        if (group == null) {
                            group = Roster.this.createGroup(groupName);
                            Roster.this.groups.put(groupName, group);
                        }
                        group.addEntryLocal(entry);
                    }
                    for (int m = 0; m < newGroupNames.size(); ++m) {
                        currentGroupNames.remove(newGroupNames.get(m));
                    }
                }
                for (int n = 0; n < currentGroupNames.size(); ++n) {
                    String groupName = (String)currentGroupNames.get(n);
                    RosterGroup group = Roster.this.getGroup(groupName);
                    group.removeEntryLocal(entry);
                    if (group.getEntryCount() != 0) continue;
                    Map map = Roster.this.groups;
                    synchronized (map) {
                        Roster.this.groups.remove(groupName);
                        continue;
                    }
                }
                Iterator it = Roster.this.getGroups();
                while (it.hasNext()) {
                    RosterGroup group = (RosterGroup)it.next();
                    if (group.getEntryCount() != 0) continue;
                    Map map = Roster.this.groups;
                    synchronized (map) {
                        Roster.this.groups.remove(group.getName());
                    }
                }
            }
            Roster roster = Roster.this;
            synchronized (roster) {
                Roster.this.rosterInitialized = true;
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            String key = Roster.this.getPresenceMapKey(from);
            if (presence.getType() == Presence.Type.AVAILABLE) {
                Map<String, Presence> userPresences;
                if (Roster.this.presenceMap.get(key) == null) {
                    userPresences = new HashMap();
                    Roster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                }
                Object object = userPresences;
                synchronized (object) {
                    userPresences.put(StringUtils.parseResource(from), presence);
                }
                object = Roster.this.entries;
                synchronized (object) {
                    Iterator i = Roster.this.entries.iterator();
                    while (i.hasNext()) {
                        RosterEntry entry = (RosterEntry)i.next();
                        if (!entry.getUser().equals(key)) continue;
                        Roster.this.fireRosterPresenceEvent(from);
                    }
                }
            }
            if (presence.getType() == Presence.Type.UNAVAILABLE) {
                Object userPresences;
                if (Roster.this.presenceMap.get(key) != null) {
                    Object object = userPresences = (Map)Roster.this.presenceMap.get(key);
                    synchronized (object) {
                        userPresences.remove(StringUtils.parseResource(from));
                    }
                    if (userPresences.isEmpty()) {
                        Roster.this.presenceMap.remove(key);
                    }
                }
                userPresences = Roster.this.entries;
                synchronized (userPresences) {
                    Iterator i = Roster.this.entries.iterator();
                    while (i.hasNext()) {
                        RosterEntry entry = (RosterEntry)i.next();
                        if (!entry.getUser().equals(key)) continue;
                        Roster.this.fireRosterPresenceEvent(from);
                    }
                }
            }
            if (presence.getType() == Presence.Type.SUBSCRIBE) {
                if (Roster.this.subscriptionMode == 0) {
                    Presence response = new Presence(Presence.Type.SUBSCRIBED);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                } else if (Roster.this.subscriptionMode == 1) {
                    Presence response = new Presence(Presence.Type.UNSUBSCRIBED);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                }
            } else if (presence.getType() == Presence.Type.UNSUBSCRIBE && Roster.this.subscriptionMode != 2) {
                Presence response = new Presence(Presence.Type.UNSUBSCRIBED);
                response.setTo(presence.getFrom());
                Roster.this.connection.sendPacket(response);
            }
        }
    }
}

